#--------------------------------------------------------------------------------------------------------------------------------
# Place this file in the scripts folder in the starsiege directory.  Make sure to back up your own registerObjects.cs if you are using a modded version.
#--------------------------------------------------------------------------------------------------------------------------------
$separator = "-----------------------";

#--------------------------------------------------------------------------------------------------------------------------------
#  To add commands to the Mission Editor's "Objects" menu
#
#  ME::RegisterObject menuCategory menuText consoleCommand
#  ME::RegisterObject menuCategory $separator
#  ME::RegisterObject $separator
#
#--------------------------------------------------------------------------------------------------------------------------------

ME::RegisterObject( Environment, Sky,                            ME::CreateObject, sky, SimSky );
ME::RegisterObject( Environment, Planet,                         ME::CreateObject, planet, SimPlanet, _B_O_G_U_S_, 0, 30, f, f, 1, 1, 1, 0, 0, 0  );
ME::RegisterObject( Environment, Stars,                          ME::CreateObject, starField, SimStarField );
ME::RegisterObject( Environment, Snowfall,                       ME::CreateObject, snowfall, Snowfall, 1, 0, 0, 0 );
ME::RegisterObject( Environment, Rain,                           ME::CreateObject, snowfall, Snowfall, 1, 0, 0, 1 );
ME::RegisterObject( Environment, $separator );
ME::RegisterObject( Environment, "ESPalette",                    ME::CreateObject, Palette, ESPalette );

#--------------------------------------------------------------------------------------------------------------------------------

ME::RegisterObject( "Mission Logic", "Sim Group",                 ME::CreateObject, Group, SimGroup );
ME::RegisterObject( "Mission Logic", "Sim Set",                   ME::CreateObject, Set, SimSet );
ME::RegisterObject( "Mission Logic", $separator );                 
ME::RegisterObject( "Mission Logic", "Shape Group",               ME::CreateObject, shapeGroup, SimShapeGroup );
ME::RegisterObject( "Mission Logic", "Shape Group Rep",           ME::CreateObject, shapeGroupRep_, ShapeGroupRep );
ME::RegisterObject( "Mission Logic", $separator );
ME::RegisterObject( "Mission Logic", "Camera Path Group",         ME::CreateObject, cameraPathGroup, SimCameraPathGroup );
ME::RegisterObject( "Mission Logic", "Camera Path Rep",           ME::CreateObject, cameraPathRep, SimCameraPathRep );
ME::RegisterObject( "Mission Logic", "Camera Waypoint",           ME::CreateObject, cameraWaypoint, SimCameraWaypoint );
ME::RegisterObject( "Mission Logic", $separator );
ME::RegisterObject( "Mission Logic", "Drop Point Group",          ME::CreateObject, DropPointGroup, ESDropPointGroup );
ME::RegisterObject( "Mission Logic", "Drop Point",                ME::CreateObject, dropPoint, SimDropPoint );
ME::RegisterObject( "Mission Logic", "Path Marker",               ME::CreateObject, marker, SimMarker );
ME::RegisterObject( "Mission Logic", "Navigation Point",          ME::CreateObject, navigationMarker, ESNavMarker );
ME::RegisterObject( "Mission Logic", $separator );
ME::RegisterObject( "Mission Logic", "Trigger",                   ME::CreateObject, trigger, SimTrigger );
ME::RegisterObject( "Mission Logic", "Magnet",                    ME::CreateObject, simMagnet, SimMagnet );
ME::RegisterObject( "Mission Logic", $separator );
ME::RegisterObject( "Mission Logic", "Sound Source",              ME::CreateObject, simSoundSource, SimSoundSource );
ME::RegisterObject( "Mission Logic", "Sound Cockpit",             ME::CreateObject, simSoundCockpit, SimSoundCockpit );
ME::RegisterObject( "Mission Logic", "Point Light",               ME::CreateObject, PointLight, SimLight, Point, 10, 1, 1, 1, 0, 0, 0);

#--------------------------------------------------------------------------------------------------------------------------------
ME::RegisterObject( $separator );

ME::RegisterObject( "Terran Vehicles", "Terran Apocalypse",                ME::CreateObject, Herc, Herc, 1 );
ME::RegisterObject( "Terran Vehicles", "Terran Minotaur",                  ME::CreateObject, Herc, Herc, 2 );
ME::RegisterObject( "Terran Vehicles", "Terran Gorgon",                    ME::CreateObject, Herc, Herc, 3 );
ME::RegisterObject( "Terran Vehicles", "Terran Talon",                     ME::CreateObject, Herc, Herc, 4 );
ME::RegisterObject( "Terran Vehicles", "Terran Basilisk",                  ME::CreateObject, Herc, Herc, 5 );
ME::RegisterObject( "Terran Vehicles", "Paladin Tank",                     ME::CreateObject, Tank, Tank, 6 );
ME::RegisterObject( "Terran Vehicles", "Myrmidon Tank",                    ME::CreateObject, Tank, Tank, 7 );
ME::RegisterObject( "Terran Vehicles", "Disruptor Tank",                   ME::CreateObject, Tank, Tank, 8 );
ME::RegisterObject( "Terran Vehicles", "Nike Artillery",                   ME::CreateObject, Tank, Tank, 133 );
ME::RegisterObject( "Terran Vehicles", "Supressor Tank",                   ME::CreateObject, Tank, Tank, 134 );

ME::RegisterObject( "Terran Vehicles", "Banshee Flyer",                    ME::CreateObject, Flyer, Flyer, 9 );
ME::RegisterObject( "Terran Vehicles", "Cargo ship",                       ME::CreateObject, Flyer, Flyer, 18 );
ME::RegisterObject( "Terran Vehicles", "Escape ship",                      ME::CreateObject, Flyer, Flyer, 19 );
ME::RegisterObject( "Terran Vehicles", "Drop ship",                        ME::CreateObject, Flyer, Flyer, 130 );
ME::RegisterObject( "Terran Vehicles", "Draco Bomber",                     ME::CreateObject, Flyer, Flyer, 131 );
ME::RegisterObject( "Terran Vehicles", "Conveyor",                         ME::CreateObject, Flyer, Flyer, 132 );
 

ME::RegisterObject( "Knight Vehicles", "Knight's Apocalypse",             ME::CreateObject, Herc, Herc, 10 );
ME::RegisterObject( "Knight Vehicles", "Knight's Minotaur",               ME::CreateObject, Herc, Herc, 11 );
ME::RegisterObject( "Knight Vehicles", "Knight's Gorgon",                 ME::CreateObject, Herc, Herc, 12 );
ME::RegisterObject( "Knight Vehicles", "Knight's Talon",                  ME::CreateObject, Herc, Herc, 13 );
ME::RegisterObject( "Knight Vehicles", "Knight's Basilisk",               ME::CreateObject, Herc, Herc, 14 );
ME::RegisterObject( "Knight Vehicles", "Knight's Paladin",                ME::CreateObject, Tank, Tank, 15 );
ME::RegisterObject( "Knight Vehicles", "Knight's Myrmidon",               ME::CreateObject, Tank, Tank, 16 );
ME::RegisterObject( "Knight Vehicles", "Knight's Disruptor",              ME::CreateObject, Tank, Tank, 17 );
ME::RegisterObject( "Knight Vehicles", "Knight's Banshee",                ME::CreateObject, Flyer, Flyer, 110 );
ME::RegisterObject( "Knight Vehicles", "Knight's Drop Ship",              ME::CreateObject, Flyer, Flyer, 111 );


ME::RegisterObject( "Cybrid Vehicles", "Cybrid Seeker",                   ME::CreateObject, Herc, Herc, 20 );
ME::RegisterObject( "Cybrid Vehicles", "Cybrid Goad",                     ME::CreateObject, Herc, Herc, 21 );
ME::RegisterObject( "Cybrid Vehicles", "Cybrid Shepherd",                 ME::CreateObject, Herc, Herc, 22 );
ME::RegisterObject( "Cybrid Vehicles", "Cybrid Adjudicator",              ME::CreateObject, Herc, Herc, 23 );
ME::RegisterObject( "Cybrid Vehicles", "Cybrid Executioner",              ME::CreateObject, Herc, Herc, 24 );
ME::RegisterObject( "Cybrid Vehicles", "Bolo Tank",                       ME::CreateObject, Tank, Tank, 25 );
ME::RegisterObject( "Cybrid Vehicles", "Recluse Tank",                    ME::CreateObject, Tank, Tank, 26 );
ME::RegisterObject( "Cybrid Vehicles", "Platinum Adjudicator (Player)",   ME::CreateObject, Herc, Herc, 55 );
ME::RegisterObject( "Cybrid Vehicles", "Platinum Executioner (Player)",   ME::CreateObject, Herc, Herc, 56 );
ME::RegisterObject( "Cybrid Vehicles", "Platinum Adjudicator",            ME::CreateObject, Herc, Herc, 27 );
ME::RegisterObject( "Cybrid Vehicles", "Platinum Executioner",            ME::CreateObject, Herc, Herc, 28 );
ME::RegisterObject( "Cybrid Vehicles", "Cybrid Artillery",                ME::CreateObject, Tank, Tank, 90 );
ME::RegisterObject( "Cybrid Vehicles", "Cybrid Advocate",                 ME::CreateObject, Flyer, Flyer, 91 );
ME::RegisterObject( "Cybrid Vehicles", "Cybrid Drop Ship",                ME::CreateObject, Flyer, Flyer, 92 );
ME::RegisterObject( "Cybrid Vehicles", "Cybrid Consul Bomber",            ME::CreateObject, Flyer, Flyer, 93 );


ME::RegisterObject( "Metagen Vehicles", "Metagen Seeker",                 ME::CreateObject, Herc, Herc, 35 );
ME::RegisterObject( "Metagen Vehicles", "Metagen Goad",                   ME::CreateObject, Herc, Herc, 36 );
ME::RegisterObject( "Metagen Vehicles", "Metagen Shepherd",               ME::CreateObject, Herc, Herc, 37 );
ME::RegisterObject( "Metagen Vehicles", "Metagen Adjudicator",            ME::CreateObject, Herc, Herc, 38 );
ME::RegisterObject( "Metagen Vehicles", "Metagen Executioner",            ME::CreateObject, Herc, Herc, 39 );


ME::RegisterObject( "Rebel Vehicles", "Rebel Emancipator",               ME::CreateObject, Herc, Herc, 30 );
ME::RegisterObject( "Rebel Vehicles", "Avenger Tank",                    ME::CreateObject, Tank, Tank, 31 );
ME::RegisterObject( "Rebel Vehicles", "Dreadnought Tank",                ME::CreateObject, Tank, Tank, 32 );
ME::RegisterObject( "Rebel Vehicles", "Rebel Olympian",                  ME::CreateObject, Herc, Herc, 33 );
ME::RegisterObject( "Rebel Vehicles", "Rebel Artillery",                 ME::CreateObject, Tank, Tank, 137 );


ME::RegisterObject( "Special Vehicles", "Harabec's Apocalypse",          ME::CreateObject, Herc, Herc, 40 );
ME::RegisterObject( "Special Vehicles", "Harabec's Predator",            ME::CreateObject, Tank, Tank, 41 );
ME::RegisterObject( "Special Vehicles", "Harabec's Super Predator",      ME::CreateObject, Tank, Tank, 45 );
ME::RegisterObject( "Special Vehicles", "Caanon's Basilisk",             ME::CreateObject, Herc, Herc, 42 );

ME::RegisterObject( "Special Vehicles", "Prometheus",                    ME::CreateObject, Herc, Herc, 29 );
ME::RegisterObject( "Special Vehicles", "Pouncer Assault Bike",          ME::CreateObject, Tank, Tank, 138 );
ME::RegisterObject( "Special Vehicles", "Starsiege Magic Bus",           ME::CreateObject, Tank, Tank, 150 );

ME::RegisterObject( "Pirate Vehicles", "Pirate's Apocalypse",            ME::CreateObject, Herc, Herc, 50 );
ME::RegisterObject( "Pirate Vehicles", "Pirate's Dreadlock",             ME::CreateObject, Tank, Tank, 51 );
ME::RegisterObject( "Pirate Vehicles", "Pirate's Emancipator",           ME::CreateObject, Herc, Herc, 52 );

ME::RegisterObject( "Drone Vehicles", "Terran Empty Cargo",               ME::CreateObject, Drone, Tank, 60 );
ME::RegisterObject( "Drone Vehicles", "Terran Ammo Cargo",                ME::CreateObject, Drone, Tank, 61 );
ME::RegisterObject( "Drone Vehicles", "Terran Big Ammo Cargo",            ME::CreateObject, Drone, Tank, 62 );
ME::RegisterObject( "Drone Vehicles", "Terran Big Personnel Cargo",       ME::CreateObject, Drone, Tank, 63 );
ME::RegisterObject( "Drone Vehicles", "Terran Fuel Cargo",                ME::CreateObject, Drone, Tank, 64 );
ME::RegisterObject( "Drone Vehicles", "Terran Minotaur Cargo",            ME::CreateObject, Drone, Tank, 65 );
ME::RegisterObject( "Drone Vehicles", "Terran Utility Truck",             ME::CreateObject, Drone, Tank, 71 );
ME::RegisterObject( "Drone Vehicles", "Terran Sovereign",                 ME::CreateObject, Tank, Tank, 135 );
ME::RegisterObject( "Drone Vehicles", "Terran Surveyor",                  ME::CreateObject, Tank, Tank, 136 );
ME::RegisterObject( "Drone Vehicles", "Terran Starefield",                ME::CreateObject, Tank, Tank,  73 );
ME::RegisterObject( "Drone Vehicles", "Rebel Empty Cargo",                ME::CreateObject, Drone, Tank, 66 );
ME::RegisterObject( "Drone Vehicles", "Rebel Ammo Cargo",                 ME::CreateObject, Drone, Tank, 67 );
ME::RegisterObject( "Drone Vehicles", "Rebel Big Cargo Transport",        ME::CreateObject, Drone, Tank, 68 );
ME::RegisterObject( "Drone Vehicles", "Rebel Bix Box Cargo Transport",    ME::CreateObject, Drone, Tank, 69 );
ME::RegisterObject( "Drone Vehicles", "Rebel Box Cargo Transport",        ME::CreateObject, Drone, Tank, 70 );
ME::RegisterObject( "Drone Vehicles", "Rebel Thumper",                    ME::CreateObject, Tank, Tank, 72 );
ME::RegisterObject( "Drone Vehicles", "Cybrid Omnicrawler",               ME::CreateObject, Drone, Tank, 94 );
ME::RegisterObject( "Drone Vehicles", "Cybrid Protector",                 ME::CreateObject, Drone, Tank, 95 );
ME::RegisterObject( "Drone Vehicles", "Cybrid Jamma",                     ME::CreateObject, Drone, Tank, 96 );

ME::RegisterObject( "Cinematic Vehicles", "Harabec's Apocalypse",          ME::CreateObject, Herc, Herc, 43 );
ME::RegisterObject( "Cinematic Vehicles", "Caanon's Basilisk",            ME::CreateObject, Herc, Herc, 44 );
#--------------------------------------------------------------------------------------------------------------------------------
#Additional Vehicles



#--------------------------------------------------------------------------------------------------------------------------------
ME::RegisterObject( $separator );

#---Turrets-------------------
ME::RegisterObject( Turrets, "Cybrid Laser Turret",              ME::CreateObject, Turret_CY_LS, Turret, 1 );
ME::RegisterObject( Turrets, "Cybrid Missle Turret",             ME::CreateObject, Turret_CY_MS, Turret, 2 );
ME::RegisterObject( Turrets, $separator );
ME::RegisterObject( Turrets, "Mars Big Cannon",                  ME::CreateObject, Turret_H_CN,   Turret, 3 );
ME::RegisterObject( Turrets, "Moon Cannon",                      ME::CreateObject, Turret_M_CN,   Turret, 25 );
ME::RegisterObject( Turrets, "Trooper Cannon",                   ME::CreateObject, Turret_T_CN,   Turret, 26 );
ME::RegisterObject( Turrets, "Desert Cannon",                    ME::CreateObject, Turret_D_CN,   Turret, 31 );
ME::RegisterObject( Turrets, $separator );
ME::RegisterObject( Turrets, "Human Desert Laser Short",         ME::CreateObject, Turret_H_D_LS, Turret, 27 );
ME::RegisterObject( Turrets, "Human Desert Laser Tall",          ME::CreateObject, Turret_H_D_LS, Turret, 28 );
ME::RegisterObject( Turrets, "Human Earth Laser Short",          ME::CreateObject, Turret_H_E_LS, Turret, 4 );
ME::RegisterObject( Turrets, "Human Earth Laser Tall",           ME::CreateObject, Turret_H_E_LS, Turret, 5 );
ME::RegisterObject( Turrets, "Human Mars Laser Short",           ME::CreateObject, Turret_H_M_LS, Turret, 6 );
ME::RegisterObject( Turrets, "Human Mars Laser Tall",            ME::CreateObject, Turret_H_M_LS, Turret, 7 );
ME::RegisterObject( Turrets, "Human Moon Laser Short",           ME::CreateObject, Turret_H_M_LS, Turret, 8 );
ME::RegisterObject( Turrets, "Human Moon Laser Tall",            ME::CreateObject, Turret_H_M_LS, Turret, 9 );
ME::RegisterObject( Turrets, "Human Titan Laser Short",          ME::CreateObject, Turret_H_T_LS, Turret, 10 );
ME::RegisterObject( Turrets, "Human Titan Laser Tall",           ME::CreateObject, Turret_H_T_LS, Turret, 11 );
ME::RegisterObject( Turrets, "Human Venus Laser Short",          ME::CreateObject, Turret_H_V_LS, Turret, 12 );
ME::RegisterObject( Turrets, "Human Venus Laser Tall",           ME::CreateObject, Turret_H_V_LS, Turret, 13 );
ME::RegisterObject( Turrets, $separator );
ME::RegisterObject( Turrets, "Human Desert Missle Short",        ME::CreateObject, Turret_H_D_MS, Turret, 29 );
ME::RegisterObject( Turrets, "Human Desert Missle Tall",         ME::CreateObject, Turret_H_D_MS, Turret, 30 );
ME::RegisterObject( Turrets, "Human Earth Missle Short",         ME::CreateObject, Turret_H_E_MS, Turret, 14 );
ME::RegisterObject( Turrets, "Human Earth Missle Tall",          ME::CreateObject, Turret_H_E_MS, Turret, 15 );
ME::RegisterObject( Turrets, "Human Mars Missle Short",          ME::CreateObject, Turret_H_M_MS, Turret, 16 );
ME::RegisterObject( Turrets, "Human Mars Missle Tall",           ME::CreateObject, Turret_H_M_MS, Turret, 17 );
ME::RegisterObject( Turrets, "Human Moon Missle Short",          ME::CreateObject, Turret_H_M_MS, Turret, 18 );
ME::RegisterObject( Turrets, "Human Moon Missle Tall",           ME::CreateObject, Turret_H_M_MS, Turret, 19 );
ME::RegisterObject( Turrets, "Human Titan Missle Short",         ME::CreateObject, Turret_H_T_MS, Turret, 20 );
ME::RegisterObject( Turrets, "Human Titan Missle Tall",          ME::CreateObject, Turret_H_T_MS, Turret, 21 );
ME::RegisterObject( Turrets, "Human Venus Missle Short",         ME::CreateObject, Turret_H_V_MS, Turret, 22 );
ME::RegisterObject( Turrets, "Human Venus Missle Tall",          ME::CreateObject, Turret_H_V_MS, Turret, 23 );

ME::RegisterObject( Turrets, $separator );
ME::RegisterObject( Turrets, "Human Desert Laser Short Rearm",   ME::CreateObject, Turret_H_D_LS, Turret, 32 );
ME::RegisterObject( Turrets, "Human Titan Laser Short Rearm",    ME::CreateObject, Turret_H_D_LS, Turret, 34 );
ME::RegisterObject( Turrets, "Trooper Cannon Rearm",             ME::CreateObject, Turret_T_CN,   Turret, 35 );
ME::RegisterObject( Turrets, "Cybrid Laser Turret Rearm",        ME::CreateObject, Turret_CY_LS,  Turret, 33 );

#---CYBRID SHAPES----------------
ME::RegisterObject( $separator );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Bomberbay",         ME::CreateObject, cBomberBay,         StaticShape, true, "cBomberbay.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Comm",              ME::CreateObject, cComm,              StaticShape, true, "cComm.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Drop Pod",          ME::CreateObject, cDropPod,           StaticShape, true, "cDropPod.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Entrance",          ME::CreateObject, cEntrance,          StaticShape, true, "cEntrance.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Generator",         ME::CreateObject, cGenerator,         StaticShape, true, "cGenerator.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Motion Detector",   ME::CreateObject, cMotiondetector,    StaticShape, true, "cMotionDetector.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Nexus",             ME::CreateObject, cNexus,             StaticShape, true, "cNexus.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Perimeter",         ME::CreateObject, cPerimeter,         StaticShape, false, "cPerimeter.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Power",             ME::CreateObject, cPower,             StaticShape, true,  "cPower.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Relay Station",     ME::CreateObject, cRelay,             StaticShape, true,  "cRelay.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Search Array",      ME::CreateObject, cSearcharray,       StaticShape, true, "cSearchArray.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Storage",           ME::CreateObject, cStorage,           StaticShape, true, "cStorage.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Tracking",          ME::CreateObject, cTracking,          StaticShape, true, "cTracking.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Uplink",            ME::CreateObject, cUplink,            StaticShape, true, "cUplink.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Wall",              ME::CreateObject, cWall,              StaticShape, true, "cWall.dts" );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Temple Wall",       ME::CreateObject, cTempleWall,        StaticShape, true, "cTempleWall.dts" );
ME::RegisterObject( "Cybrid Shapes", "Prometheus' Hut(ZED)",     ME::CreateObject, cTemple,            StaticShape, true, "cTemple.dts" );
ME::RegisterObject( "Cybrid Shapes", $separator );
ME::RegisterObject( "Cybrid Shapes", "Beacon         (ZED)",     ME::CreateObject, cbeacon,            StaticInterior, "cBeacon.dis" );
ME::RegisterObject( "Cybrid Shapes", "Landing Pad    (ZED)",     ME::CreateObject, clandpad,           StaticInterior, "clandpad.dis" );
ME::RegisterObject( "Cybrid Shapes", "Large Platform (ZED)",     ME::CreateObject, cbrid_p1,           StaticInterior, "cbrid_p1.dis" );
ME::RegisterObject( "Cybrid Shapes", "Prometheus Base(ZED)",     ME::CreateObject, cprombase,          StaticInterior, "cPromBase.dis" );
ME::RegisterObject( "Cybrid Shapes", "Small Platform (ZED)",     ME::CreateObject, cbrid_p2,           StaticInterior, "cbrid_p2.dis" );
ME::RegisterObject( "Cybrid Shapes", "Silo           (ZED)",     ME::CreateObject, csilo,              StaticInterior, "csilo.dis" );
ME::RegisterObject( "Cybrid Shapes", "Silo Platform  (ZED)",     ME::CreateObject, csilo_p1,           StaticInterior, "csilo_p1.dis" );
ME::RegisterObject( "Cybrid Shapes", "Tunnels        (ZED)",     ME::CreateObject, cbrid,              StaticInterior, "cbrid.dis" );
ME::RegisterObject( "Cybrid Shapes", $separator );
ME::RegisterObject( "Cybrid Shapes", "Cybrid Tower 1",           ME::CreateObject, cbig1,			 StaticInterior, "cbig1.dis");
ME::RegisterObject( "Cybrid Shapes", "Cybrid Bridge",		 ME::CreateObject, cbridge,		 StaticInterior, "cbridge.dis");



#---DESERT EARTH SHAPES---------
ME::RegisterObject( "Desert Shapes", "Desert Big Dish",          ME::CreateObject, hDesertBigDish,     StaticShape, true, "hDesertBigDish.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Church",            ME::CreateObject, hDesertchurch,      StaticShape, true, "hDesertchurch.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Defense",           ME::CreateObject, hDesertDefense,     StaticShape, true, "hDesertDefense.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Dwelling",          ME::CreateObject, hDesertdwelling,    StaticShape, true, "hDesertdwelling.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Garage",            ME::CreateObject, hDesertgarage,      StaticShape, true, "hDesertgarage.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Gathering",         ME::CreateObject, hDesertgathering,   StaticShape, true, "hDesertgathering.dts" );
ME::RegisterObject( "Desert Shapes", "Desert LandMine",          ME::CreateObject, hDesertMine,        StaticShape, true, "hDesertMine.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Power",             ME::CreateObject, hDesertpower,       StaticShape, true, "hDesertpower.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Silo",              ME::CreateObject, hDesertsilo,        StaticShape, true, "hDesertsilo.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Sludge",            ME::CreateObject, hDesertsludge,      StaticShape, true, "hDesertsludge.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Uplink",            ME::CreateObject, hDesertuplink,      StaticShape, true, "hDesertuplink.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Vapor",             ME::CreateObject, hDesertvapor,       StaticShape, true, "hDesertvapor.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Water Tower",       ME::CreateObject, hDesertWaterTower,  StaticShape, true, "hDesertWaterTower.dts" );
ME::RegisterObject( "Desert Shapes", $separator);
ME::RegisterObject( "Desert Shapes", "Desert Troop Barracks",     ME::CreateObject, hDesertTroopBarracks,       StaticShape, true, "hDesertTroopBarracks.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Troop Barracks, sm", ME::CreateObject, hDesertSmallTroopBarracks,  StaticShape, true, "hDesertSmallTroopBarracks.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Troop Com, sm",      ME::CreateObject, hDesertSmallTroopCom,   StaticShape, true, "hDesertSmallTroopCom.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Troop Garage",      ME::CreateObject, hDesertTroopGarage,     StaticShape, true, "hDesertTroopGarage.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Troop Hall",        ME::CreateObject, hDesertTroopHall,       StaticShape, true, "hDesertTroopHall.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Troop HQ, sm",      ME::CreateObject, hDesertSmallTroopHQ,    StaticShape, true, "hDesertSmallTroopHQ.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Pillar1",           ME::CreateObject, hdesertpillar1,         StaticShape, true, "hdesertpillar_1.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Pillar2",           ME::CreateObject, hdesertpillar2,         StaticShape, true, "hdesertpillar_2.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Pillar3",           ME::CreateObject, hdesertpillar3,         StaticShape, true, "hdesertpillar_3.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Pillar4",           ME::CreateObject, hdesertpillar4,         StaticShape, true, "hdesertpillar_4.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Pillar5",           ME::CreateObject, hdesertpillar5,         StaticShape, true, "hdesertpillar_5_tall.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Pillar6",           ME::CreateObject, hdesertpillar6,         StaticShape, true, "hdesertpillar_6_tall.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Altar",             ME::CreateObject, hdesertaltar,           StaticShape, true, "hdesertpillar_altar.dts" );
ME::RegisterObject( "Desert Shapes", "Desert Hall",              ME::CreateObject, hdeserthall,            StaticShape, true, "hdesertpillar_hall.dts" );

ME::RegisterObject( "Desert Shapes", $separator);
ME::RegisterObject( "Desert Shapes", "Pyramid 1(ZED)",           ME::CreateObject, hpyramid,           StaticInterior, "hpyramid.dis" );
ME::RegisterObject( "Desert Shapes", "Pyramid 2(ZED)",           ME::CreateObject, hpyramid2,          StaticInterior, "hpyramid2.dis" );
ME::RegisterObject( "Desert Shapes", "Pyramid 3(ZED)",           ME::CreateObject, hpyramid3,          StaticInterior, "hpyramid3.dis" );
ME::RegisterObject( "Desert Shapes", $separator);
ME::RegisterObject( "Desert Shapes", "Desert Tower 1",    ME::CreateObject, hbigsand1m,	       StaticInterior, "hbigsand1d.dis");
ME::RegisterObject( "Desert Shapes", "Desert Tower 2",    ME::CreateObject, hbigsand2m,	       StaticInterior, "hbigsand2d.dis");
ME::RegisterObject( "Desert Shapes", "Desert Tower 3",    ME::CreateObject, hbigsand3m,	       StaticInterior, "hbigsand3d.dis");
ME::RegisterObject( "Desert Shapes", "Desert Tower 4",    ME::CreateObject, hbigsand4m,	       StaticInterior, "hbigsand4d.dis");
ME::RegisterObject( "Desert Shapes", "Desert Tower 5",    ME::CreateObject, hbigsand5m,	       StaticInterior, "hbigsand5d.dis");
ME::RegisterObject( "Desert Shapes", "Desert Tower 6",    ME::CreateObject, hbigsand6m,	       StaticInterior, "hbigsand6d.dis");
ME::RegisterObject( "Desert Shapes", "Desert Ruins 1",    ME::CreateObject, hruinsd1,	           	StaticInterior, "hruinsd1.dis");
ME::RegisterObject( "Desert Shapes", "Desert Ruins 2",    ME::CreateObject, hruinsd2,	           	StaticInterior, "hruinsd2.dis");
ME::RegisterObject( "Desert Shapes", "Desert Ruins 3",    ME::CreateObject, hruinsd3,	           	StaticInterior, "hruinsd3.dis");
ME::RegisterObject( "Desert Shapes", "Desert Ruins 4",    ME::CreateObject, hruinsd4,	           	StaticInterior, "hruinsd4.dis");
ME::RegisterObject( "Desert Shapes", "Novegate",	  ME::CreateObject, hnovagated, 		  	StaticInterior, "hnovagated.dis");



#---GENERIC EARTH SHAPES----
ME::RegisterObject( "Earth Shapes", "Troop Barracks",             ME::CreateObject, hTroopbarracks,     StaticShape, true, "hTroopbarracks.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Barracks, Small",      ME::CreateObject, hTroopbarrackssm,   StaticShape, true, "hTroopbarrackssm.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Bigdish",              ME::CreateObject, hTroopbigdish,      StaticShape, true, "hTroopbigdish.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Comm",                 ME::CreateObject, hTroopcomm,         StaticShape, true, "hTroopcomm.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Energy Projector",     ME::CreateObject, htroop_orbital_power,   StaticShape, true, "htroop_orbital_power.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Garage",               ME::CreateObject, hTroopgarage,       StaticShape, true, "hTroopgarage.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Garage, Small",        ME::CreateObject, hTroopgaragesm,     StaticShape, true, "hTroopgaragesm.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Generator",            ME::CreateObject, hTroopgenerator,    StaticShape, true, "hTroopgenerator.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Hall",                 ME::CreateObject, hTroophall,         StaticShape, true, "hTroophall.dts" );
ME::RegisterObject( "Earth Shapes", "Troop HQ",                   ME::CreateObject, hTroophq,           StaticShape, true, "hTroophq.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Listen",               ME::CreateObject, hTrooplisten,       StaticShape, true, "hTrooplisten.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Power",                ME::CreateObject, hTrooppower,        StaticShape, true, "hTrooppower.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Supply",               ME::CreateObject, hTroopsupply,       StaticShape, true, "hTroopsupply.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Supply Dump",          ME::CreateObject, hTroop_supply_dump, StaticShape, true, "hTroop_supply_dump.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Trackbase",            ME::CreateObject, hTrooptrackbase,    StaticShape, true, "hTrooptrackbase.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Trackdish",            ME::CreateObject, hTrooptrackdish,    StaticShape, true, "hTrooptrackdish.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Uplink",               ME::CreateObject, hTroopuplink,       StaticShape, true, "hTroopuplink.dts" );
ME::RegisterObject( "Earth Shapes", "Troop Planet Defense",       ME::CreateObject, hTroopPlanetDefense,    StaticShape, true, "hTroopPlanetDefense.dts" );
ME::RegisterObject( "Earth Shapes", $separator);
ME::RegisterObject( "Earth Shapes", "Bridge           (ZED)",     ME::CreateObject, hbridgee,           StaticInterior, "hbridgee.dis" );
ME::RegisterObject( "Earth Shapes", "Garage           (ZED)",     ME::CreateObject, hgaragee,           StaticInterior, "hgaragee.dis" );
ME::RegisterObject( "Earth Shapes", "Landing Pad      (ZED)",     ME::CreateObject, hlandpade,          StaticInterior, "hlandpade.dis" );
ME::RegisterObject( "Earth Shapes", "Landpad Platform (ZED)",     ME::CreateObject, hlandpade_p1,       StaticInterior, "hlandpade_p1.dis" );
ME::RegisterObject( "Earth Shapes", "Hangar           (ZED)",     ME::CreateObject, hhangare,           StaticInterior, "hhangare.dis" );
ME::RegisterObject( "Earth Shapes", "Hangar Platform  (ZED)",     ME::CreateObject, hhangare_p1,        StaticInterior, "hhangare_p1.dis" );
ME::RegisterObject( "Earth Shapes", "Airport          (ZED)",     ME::CreateObject, hairporte,          StaticInterior, "hairporte.dis" );
ME::RegisterObject( "Earth Shapes", "Airport Platform (ZED)",     ME::CreateObject, hairporte_p1,       StaticInterior, "hairporte_p1.dis" );
ME::RegisterObject( "Earth Shapes", "Huge Wall        (ZED)",     ME::CreateObject, hwallhuge,          StaticInterior, "hwallhuge.dis" );
ME::RegisterObject( "Earth Shapes", $separator);
ME::RegisterObject( "Earth Shapes", "Gathering",                  ME::CreateObject, hgathering,         StaticShape, true, "hgathering.dts" );
ME::RegisterObject( "Earth Shapes", "Big Castlet      (ZED)",     ME::CreateObject, hbigcastlet,        StaticInterior, "hbigcastlet.dis" );
ME::RegisterObject( "Earth Shapes", "Huge House       (ZED)",     ME::CreateObject, hhugehouse1,        StaticInterior, "hhugehouse1.dis" );

#---EUROPA SHAPES------------
ME::RegisterObject( "Europa Shapes", "Europa Rock1",          ME::CreateObject, xeuroparock1,       StaticShape, "xeuroparock01.dts" );
ME::RegisterObject( "Europa Shapes", "Europa Rock2",          ME::CreateObject, xeuroparock2,       StaticShape, "xeuroparock02.dts" );
ME::RegisterObject( "Europa Shapes", "Europa Rock3",          ME::CreateObject, xeuroparock3,       StaticShape, "xeuroparock03.dts" );
ME::RegisterObject( "Europa Shapes", $separator);
ME::RegisterObject( "Europa Shapes", "Heal (ZED)", 			ME::CreateObject, hheale,       	StaticInterior, "hheale.dis" );
ME::RegisterObject( "Europa Shapes", "Ammo (ZED)", 			ME::CreateObject, hammoe,       	StaticInterior, "hammoe.dis" );
ME::RegisterObject( "Europa Shapes", "Trooper Hanger (ZED)", 	ME::CreateObject, hTroophouseE,	StaticInterior, "hTroophouseE.dis" );
ME::RegisterObject( "Europa Shapes", "Ruins1 (ZED)", 	        ME::CreateObject, hRuinsT,	    StaticInterior, "hRuinsT.dis" );
ME::RegisterObject( "Europa Shapes", "Ruins2 (ZED)", 	        ME::CreateObject, hRuinsT2,	    StaticInterior, "hRuinsT2.dis" );
ME::RegisterObject( "Europa Shapes", "Ruins3 (ZED)", 	        ME::CreateObject, hRuinsT3,	    StaticInterior, "hRuinsT3.dis" );
ME::RegisterObject( "Europa Shapes", $separator);


#---SNOW SHAPES--------------
ME::RegisterObject( "Ice Shapes", "Office",                      ME::CreateObject, hOffice,            StaticShape, true, "hOffice.dts" );
ME::RegisterObject( "Ice Shapes", "Solar Station",               ME::CreateObject, hSnowSolar,         StaticShape, true, "hSolarStation.dts" );
ME::RegisterObject( "Ice Shapes", "Gathering Hall",              ME::CreateObject, hSnowGath,          StaticShape, true, "hSnowGathering.dts" );
ME::RegisterObject( "Ice Shapes", "Snowlland",                   ME::CreateObject, hSnowLand,          StaticShape, true, "hSnowlland.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Church",                 ME::CreateObject, hSnowChurch,        StaticShape, true, "hSnowChurch.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Com",                    ME::CreateObject, hSnowCom,           StaticShape, true, "hSnowCom.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Residence",              ME::CreateObject, hSnowRes,           StaticShape, true, "hSnowResidence.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Storage",                ME::CreateObject, hSnowStor,          StaticShape, true, "hSnowStorage.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Uplink",                 ME::CreateObject, hSnowUplink,        StaticShape, true, "hSnowUplink.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Rock1",                  ME::CreateObject, hSnowRock1,         StaticShape, false,"xSnowRock1.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Rock2",                  ME::CreateObject, hSnowRock2,         StaticShape, false,"xSnowRock2.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Rock3",                  ME::CreateObject, hSnowRock3,         StaticShape, false,"xSnowRock3.dts" );
ME::RegisterObject( "Ice Shapes", "Snow Tree",                   ME::CreateObject, hTree,              StaticShape, false,"xTree.dts" );
ME::RegisterObject( "Ice Shapes", "SnowMan",                     ME::CreateObject, hSnowMan,           StaticShape, false,"xSnowMan.dts" );
ME::RegisterObject( "Ice Shapes", $separator );
ME::RegisterObject( "Ice Shapes", "Airport     (ZED)",           ME::CreateObject, hairporta,          StaticInterior, "hairporta.dis" );
ME::RegisterObject( "Ice Shapes", "Gate        (ZED)",           ME::CreateObject, hgatea,             StaticInterior, "hgatea.dis" );
ME::RegisterObject( "Ice Shapes", "Landing Pad (ZED)",           ME::CreateObject, hlandpada,          StaticInterior, "hlandpada.dis" );
ME::RegisterObject( "Ice Shapes", "Pad Office  (ZED)",           ME::CreateObject, hpadofficea,        StaticInterior, "hpadofficea.dis" );
ME::RegisterObject( "Ice Shapes", "Heal Pad    (ZED)",           ME::CreateObject, hheal2a,            StaticInterior, "hheal2a.dis" );
ME::RegisterObject( "Ice Shapes", "Reload Pad  (ZED)",           ME::CreateObject, hammo2a,            StaticInterior, "hammo2a.dis" );
ME::RegisterObject( "Ice Shapes", "Heal        (ZED)",           ME::CreateObject, hheal2a,       StaticInterior, "hheal2a.dis" );
ME::RegisterObject( "Ice Shapes", "Ammo        (ZED)",           ME::CreateObject, hammo2a,       StaticInterior, "hammo2a.dis" );

#---MARS SHAPES (A-N) ---------------
ME::RegisterObject( "Mars Shapes A-N", "Atmosphere",             ME::CreateObject, hAtmos,             StaticShape, true, "hAtmos.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Barracks",               ME::CreateObject, hMarsBarracks,      StaticShape, true, "hMarsBarracks.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Crane",                  ME::CreateObject, hCrane,             StaticShape, true, "hCrane.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Civilian Garage",        ME::CreateObject, hMarsCivGarage,     StaticShape, true, "hMarsCivGarage.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Comm Tower",             ME::CreateObject, hMarsCommTower,     StaticShape, true, "hMarsCommTower.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Farm House",             ME::CreateObject, hMarsFarmHouse,     StaticShape, true, "hMarsFarmHouse.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Fertillizer",            ME::CreateObject, hFertillizer,       StaticShape, true, "hFertillizer.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Fusion Reactor",         ME::CreateObject, hMarsFusionReactor, StaticShape, true, "hMarsFusionReactor.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Garage",                 ME::CreateObject, hGarage,            StaticShape, true, "hGarage.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Hanger",                 ME::CreateObject, hMarsHanger,        StaticShape, true, "hMarsHanger.dts" );
ME::RegisterObject( "Mars Shapes A-N", "LandMine",               ME::CreateObject, hMarsMine,          StaticShape, true, "hMarsMine.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Mass Driver",            ME::CreateObject, hMarsMassDriver,    StaticShape, true, "hMarsMassDriver.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Meeting Hall",           ME::CreateObject, hMeethall,          StaticShape, true, "hMeethall.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Mine Train",             ME::CreateObject, hMarsMineTrain,     StaticShape, true, "hMarsMineTrain.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Mine Train Cargo",       ME::CreateObject, hMarsMineTrain_cargo,     StaticShape, true, "hMarsMineTrain_cargo.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Monument",               ME::CreateObject, XMonument,          StaticShape, true,"xMonument.dts" );
ME::RegisterObject( "Mars Shapes A-N", "Mars(only)flash", 	 ME::CreateObject, hMarsMine_FLASH, 	StaticShape, true, "hMarsMine_FLASH.DTS");

#---MARS SHAPES (P-Z) ---------------
ME::RegisterObject( "Mars Shapes P-Z", "Perimeter Fence",            ME::CreateObject, hPerimeter,         StaticShape, true, "hPerimeter.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "PileDriver",                 ME::CreateObject, hMarsPileDriver,    StaticShape, true, "hMarsPiledriver.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Police Flag",                ME::CreateObject, xMarsFlag_Police,   StaticShape, true, "xMarsFlag_Police.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Police (FIN)",               ME::CreateObject, hPolicefin,         StaticShape, true, "hPolicefin.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Police (HQ)",                ME::CreateObject, hPolicehq,          StaticShape, true, "hPolicehq.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Power (FIN)",                ME::CreateObject, hPowerfin,          StaticShape, true, "hPowerfin.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Rebel Flag",                 ME::CreateObject, xMarsFlag_Rebel,    StaticShape, true, "xMarsFlag_Rebel.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Refinery",                   ME::CreateObject, hRefinery,          StaticShape, true, "hRefinery.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Residential Big",            ME::CreateObject, hMarsResidentialBig,    StaticShape, true, "hMarsResidentialBig.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Residential Small",          ME::CreateObject, hMarsResidentialSmall,  StaticShape, true, "hMarsResidentialSmall.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Residential Small NODOOR",   ME::CreateObject, hMarsResidentialSmall_NODOOR,  StaticShape, true, "hMarsResidentialSmall_NODOOR.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "StreetLight",                ME::CreateObject, hMarsStreetlight,   StaticShape, true, "hMarsStreetlight.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Supply Dump",                ME::CreateObject, hMarsSupplyDump ,   StaticShape, true, "hMarsSupplyDump.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Tracking Station",           ME::CreateObject, hTracking,          StaticShape, true, "hTracking.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Water Tower",                ME::CreateObject, hMarsWaterTower,        StaticShape, true, "hMarsWaterTower.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Water Converter",            ME::CreateObject, hMarsWaterConverter,    StaticShape, true, "hMarsWaterConverter.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Uplink Station",             ME::CreateObject, hUplink,            StaticShape, true, "hUplink.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Wall (NORMAL)",              ME::CreateObject, hWall,              StaticShape, true,"hWall.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Big Wall 1",            	   ME::CreateObject, hMarsBigWall_1,     StaticShape, true, "hMarsBigWall_1.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Big Wall 2",            	   ME::CreateObject, hMarsBigWall_2,     StaticShape, true, "hMarsBigWall_2.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Big Wall 3",            	   ME::CreateObject, hMarsBigWall_3,     StaticShape, true, "hMarsBigWall_3.dts" );
ME::RegisterObject( "Mars Shapes P-Z", $separator);
ME::RegisterObject( "Mars Shapes P-Z", "Mars Rock, 1",               ME::CreateObject, xMarsrock1,         StaticShape, false,"xMarsrock1.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Mars Rock, 2",               ME::CreateObject, xMarsrock2,         StaticShape, false,"xMarsrock2.dts" );
ME::RegisterObject( "Mars Shapes P-Z", "Mars Rock, 3",               ME::CreateObject, xMarsrock3,         StaticShape, false,"xMarsrock3.dts" );

#--Mars Interior Shapes
ME::RegisterObject( "Mars Interior Shapes", "Bridge, sm",           ME::CreateObject, hbridge2m,          StaticInterior, "hbridge2m.dis" );
ME::RegisterObject( "Mars Interior Shapes", "Bridge, lg",           ME::CreateObject, hbridgem,           StaticInterior, "hbridgem.dis" );
ME::RegisterObject( "Mars Interior Shapes", "Bridge, post",         ME::CreateObject, hbridgepostm,       StaticInterior, "hbridgepostm.dis" );
ME::RegisterObject( "Mars Interior Shapes", "Garage",               ME::CreateObject, hgaragem,           StaticInterior, "hgaragem.dis" );
ME::RegisterObject( "Mars Interior Shapes", "Hangar ",              ME::CreateObject, hhangarm,           StaticInterior, "hhangarm.dis" );
ME::RegisterObject( "Mars Interior Shapes", "Landing Pad       ",   ME::CreateObject, hLandPadM,	       StaticInterior, "hLandPadM.dis");
ME::RegisterObject( "Mars Interior Shapes", "Landing Pad, lg ",     ME::CreateObject, hLandPad2M,	       StaticInterior, "hLandPad2M.dis");
ME::RegisterObject( "Mars Interior Shapes", "Mass Platform     ",   ME::CreateObject, hmassplatm,	       StaticInterior, "hmassplatm.dis");
ME::RegisterObject( "Mars Interior Shapes", "Platform" ,            ME::CreateObject, hplatformm,         StaticInterior, "hplatformm.dis" );
ME::RegisterObject( "Mars Interior Shapes", "Quarry ",              ME::CreateObject, hquarrym,           StaticInterior, "hquarrym.dis" );
ME::RegisterObject( "Mars Interior Shapes", "Heal Pad ",            ME::CreateObject, hheal2m,            StaticInterior, "hheal2m.dis" );
ME::RegisterObject( "Mars Interior Shapes", "Ammo Pad ",            ME::CreateObject, hammo2m,            StaticInterior, "hammo2m.dis" );
ME::RegisterObject( "Mars Interior Shapes", $separator );
ME::RegisterObject( "Mars Interior Shapes", "Fertillizer Ruin1 ",   ME::CreateObject, hfertruinm,	       StaticInterior, "hfertruinm.dis");
ME::RegisterObject( "Mars Interior Shapes", "Fertillizer Ruin2 ",   ME::CreateObject, hfertruin2m,        StaticInterior, "hfertruin2m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Fertillizer Ruin3 ",   ME::CreateObject, hfertruin3m,	       StaticInterior, "hfertruin3m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Building Ruin1 ",   ME::CreateObject, hruinsm,	       	   StaticInterior, "hRuinsM.dis");
ME::RegisterObject( "Mars Interior Shapes", "Building Ruin2 ",   ME::CreateObject, hruinsm2,	       StaticInterior, "hRuinsM2.dis");
ME::RegisterObject( "Mars Interior Shapes", "Building Ruin3 ",   ME::CreateObject, hruinsm3,	       StaticInterior, "hRuinsM3.dis");
ME::RegisterObject( "Mars Interior Shapes", "Building Ruin4 ",   ME::CreateObject, hruinsm4,	       StaticInterior, "hRuinsM4.dis");
ME::RegisterObject( "Mars Interior Shapes", "Building Ruin6 ",   ME::CreateObject, hruinsm6,	       StaticInterior, "hRuinsM6.dis");
ME::RegisterObject( "Mars Interior Shapes", $separator );
ME::RegisterObject( "Mars Interior Shapes", "Big House  ",   ME::CreateObject, hbighousem,	       StaticInterior, "hbighousem.dis");
ME::RegisterObject( "Mars Interior Shapes", "Big Hump   ",   ME::CreateObject, hBigHumpm,	       StaticInterior, "hbighumpm.dis");
ME::RegisterObject( "Mars Interior Shapes", "Big House2 ",   ME::CreateObject, hbighouse2m,	       StaticInterior, "hbighouse2m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Big Gully  ",   ME::CreateObject, hBigGullym,	       StaticInterior, "hBigGullym.dis");
ME::RegisterObject( "Mars Interior Shapes", "Big Cargo  ",   ME::CreateObject, hBigCargom,	       StaticInterior, "hBigCargom.dis");
ME::RegisterObject( "Mars Interior Shapes", "Big Wall   ",   ME::CreateObject, hbigwall1m,	       StaticInterior, "hbigwall1m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Big Ammo   ",   ME::CreateObject, hBigAmmo,	       StaticInterior, "hBigAmmo.dis");
ME::RegisterObject( "Mars Interior Shapes", "Big Healing",   ME::CreateObject, hBigHealing,	       StaticInterior, "hBigHealing.dis");
ME::RegisterObject( "Mars Interior Shapes", "Big Mole   ",   ME::CreateObject, hBigMolem,	       StaticInterior, "hbigmolem.dis");
ME::RegisterObject( "Mars Interior Shapes", $separator );
ME::RegisterObject( "Mars Interior Shapes", "Mars Tower 1",        ME::CreateObject, hbigmars1m,	       StaticInterior, "hbigmars1m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Mars Tower 2",        ME::CreateObject, hbigmars2m,	       StaticInterior, "hbigmars2m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Mars Tower 3",        ME::CreateObject, hbigmars3m,	       StaticInterior, "hbigmars3m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Mars Tower 4",        ME::CreateObject, hbigmars4m,	       StaticInterior, "hbigmars4m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Mars Tower 5",        ME::CreateObject, hbigmars5m,	       StaticInterior, "hbigmars5m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Mars Tower 6",        ME::CreateObject, hbigmars6m,	       StaticInterior, "hbigmars6m.dis");
ME::RegisterObject( "Mars Interior Shapes", "Mars Tower Ruin 2",        ME::CreateObject, hbigmars2mruin,	       StaticInterior, "hbigmars2mruin.dis");
ME::RegisterObject( "Mars Interior Shapes", "Mars Tower Ruin 3",        ME::CreateObject, hbigmars3mruin,	       StaticInterior, "hbigmars3mruin.dis");
ME::RegisterObject( "Mars Interior Shapes", $separator );



#---MERCURY SHAPES------------
ME::RegisterObject( "Mercury Shapes", "Mercury LandMine",        ME::CreateObject, hMercuryMine,       StaticShape, true, "hMercuryMine.dts" );
ME::RegisterObject( "Mercury Shapes", "Mercury Rock1",           ME::CreateObject, xmercuryrock1,      StaticShape, false,"xmercuryrock01.dts" );
ME::RegisterObject( "Mercury Shapes", "Mercury Rock2",           ME::CreateObject, xmercuryrock2,      StaticShape, false,"xmercuryrock02.dts" );
ME::RegisterObject( "Mercury Shapes", "Mercury Rock3",           ME::CreateObject, xmercuryrock3,      StaticShape, false,"xmercuryrock03.dts" );

#---MOON SHAPES--------------
ME::RegisterObject( "Moon Shapes", "Moon Barracks",              ME::CreateObject, hMoonbarracks,      StaticShape, true, "hMoonbarracks.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Bigdish",               ME::CreateObject, hMoonbigdish,       StaticShape, true, "hMoonbigdish.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Gather",                ME::CreateObject, hMoongather,        StaticShape, true, "hMoongather.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Generator",             ME::CreateObject, hMoongenerator,     StaticShape, true, "hMoongenerator.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Listen",                ME::CreateObject, hMoonlisten,        StaticShape, true, "hMoonlisten.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Power",                 ME::CreateObject, hMoonpower,         StaticShape, true, "hMoonpower.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Refinery",              ME::CreateObject, hMoonrefinery,      StaticShape, true, "hMoonrefinery.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Residence",             ME::CreateObject, hMoonresidence,     StaticShape, true, "hMoonresidence.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Silos",                 ME::CreateObject, hMoonsilos,         StaticShape, true, "hMoonsilos.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Uplink",                ME::CreateObject, hMoonuplink,        StaticShape, true, "hMoonuplink.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Wall",                  ME::CreateObject, hMoonwall,          StaticShape, false,"hMoonwall.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Wallcap",               ME::CreateObject, hMoonwallcap,       StaticShape, false,"hMoonwallcap.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Walldoor",              ME::CreateObject, hMoonwalldoor,      StaticShape, false,"hMoonwalldoor.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Planet Defense",        ME::CreateObject, hMoonPlanetDefense, StaticShape, true, "hMoonPlanetDefense.dts" );
ME::RegisterObject( "Moon Shapes", $separator );
ME::RegisterObject( "Moon Shapes", "Moon Trooper Com",           ME::CreateObject, hMoonCom,           StaticShape, true, "hMoontroopercom.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Trooper HQ",            ME::CreateObject, hMoonHQ,            StaticShape, true, "hMoontrooperhq.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Trooper Silos",         ME::CreateObject, hMoonSilos,         StaticShape, true, "hMoontroopersilos.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Trooper Storage",       ME::CreateObject, hMoonStorage,       StaticShape, true, "hMoontrooperstorage.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Trooper Tracking",      ME::CreateObject, hMoontracking,      StaticShape, true, "hMoontrooptracking.dts" );
ME::RegisterObject( "Moon Shapes", $separator );
ME::RegisterObject( "Moon Shapes", "Landing Pad  (ZED)",         ME::CreateObject, hlandpadl,          StaticInterior, "hlandpadl.dis" );
ME::RegisterObject( "Moon Shapes", "Mine Hallway (ZED)",         ME::CreateObject, hminel,             StaticInterior, "hminel.dis" );
ME::RegisterObject( "Moon Shapes", "Mine Lift    (ZED)",         ME::CreateObject, hmineliftl,         StaticInterior, "hmineliftl.dis" );
ME::RegisterObject( "Moon Shapes", "Silo         (ZED)",         ME::CreateObject, hsilol,             StaticInterior, "hsilol.dis" );
ME::RegisterObject( "Moon Shapes", "Spaceport    (ZED)",         ME::CreateObject, hlunaport,          StaticInterior, "hlunaport.dis" );
ME::RegisterObject( "Moon Shapes", $separator );
ME::RegisterObject( "Moon Shapes", "Moon Tower 1 (ZED)",         ME::CreateObject, hbigluna1,          StaticInterior, "hbigluna1.dis" );
ME::RegisterObject( "Moon Shapes", "Moon Tower 2 (ZED)",         ME::CreateObject, hbigluna2,          StaticInterior, "hbigluna2.dis" );
ME::RegisterObject( "Moon Shapes", "Moon Tower 3 (ZED)",         ME::CreateObject, hbigluna3,          StaticInterior, "hbigluna3.dis" );
ME::RegisterObject( "Moon Shapes", "Moon Tower 4 (ZED)",         ME::CreateObject, hbigluna4,          StaticInterior, "hbigluna4.dis" );
ME::RegisterObject( "Moon Shapes", "Moon Tower 5 (ZED)",         ME::CreateObject, hbigluna5,          StaticInterior, "hbigluna5.dis" );
ME::RegisterObject( "Moon Shapes", "Moon Tower 6 (ZED)",         ME::CreateObject, hbigluna6,          StaticInterior, "hbigluna6.dis" );
ME::RegisterObject( "Moon Shapes", $separator );
ME::RegisterObject( "Moon Shapes", "Moon Rock1",                 ME::CreateObject, xmoonrock1,         StaticShape, false,"xmoonrock01.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Rock2",                 ME::CreateObject, xmoonrock2,         StaticShape, false,"xmoonrock02.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Rock3",                 ME::CreateObject, xmoonrock3,         StaticShape, false,"xmoonrock03.dts" );
ME::RegisterObject( "Moon Shapes", $separator );
ME::RegisterObject( "Moon Shapes", "Apollo",                     ME::CreateObject, xApollo,          StaticShape, true, "xApollo.dts" );
ME::RegisterObject( "Moon Shapes", "Moon Flag",                  ME::CreateObject, xMoonflag,          StaticShape, false,"xMoonflag.dts" );
ME::RegisterObject( "Moon Shapes", $separator );
ME::RegisterObject( "Moon Shapes", "Moon Mass Driver",           ME::CreateObject, hMoonMassDriver,    StaticShape, true, "hMoonMassDriver.dts" );

#---PLUTO SHAPES------------
ME::RegisterObject( "Pluto Shapes", "Pluto Rock1",               ME::CreateObject, xplutorock1,        StaticShape, false,"xplutorock01.dts" );
ME::RegisterObject( "Pluto Shapes", "Pluto Rock2",               ME::CreateObject, xplutorock2,        StaticShape, false,"xplutorock02.dts" );
ME::RegisterObject( "Pluto Shapes", "Pluto Rock3",               ME::CreateObject, xplutorock3,        StaticShape, false,"xplutorock03.dts" );

#---TEMPERATE SHAPES---------
ME::RegisterObject( "Temperate Shapes", "Kong Civil",            ME::CreateObject, hKongcivil,         StaticShape, true, "hKongcivil.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong Gate",             ME::CreateObject, hKonggate,          StaticShape, true, "hKonggate.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong Gathering",        ME::CreateObject, hKonggathering,     StaticShape, true, "hKonggathering.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong House",            ME::CreateObject, hKonghouse,         StaticShape, true, "hKonghouse.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong Deck House",       ME::CreateObject, hKongdeckhouse,     StaticShape, true, "hKongdeckhouse.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong Office",           ME::CreateObject, hKongoffice,        StaticShape, true, "hKongoffice.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong Pagoda",           ME::CreateObject, hKongpagoda,        StaticShape, true, "hKongpagoda.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong Sludge",           ME::CreateObject, hKongsludge,        StaticShape, true, "hKongsludge.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong Temple",           ME::CreateObject, hKongtemple,        StaticShape, true, "hKongtemple.dts" );
ME::RegisterObject( "Temperate Shapes", "Kong High Temple",      ME::CreateObject, hKonglgtemple,      StaticShape, true, "hKonglgtemple.dts" );
ME::RegisterObject( "Temperate Shapes", $separator );
ME::RegisterObject( "Temperate Shapes", "Hong Temple (ZED)",	   ME::CreateObject, hHongTemple,		StaticInterior, "hHongTemple.dis" );
ME::RegisterObject( "Temperate Shapes", "Kong Heal   (ZED)",	   ME::CreateObject, heal,				StaticInterior, "hkongheal.dis" );
ME::RegisterObject( "Temperate Shapes", "Kong Reload (ZED)",	   ME::CreateObject, reload,				StaticInterior, "hkongammo.dis" );
ME::RegisterObject( "Temperate Shapes", $separator );
ME::RegisterObject( "Temperate Shapes", "Kong Tower 1",          ME::CreateObject, hbigkong1t,	       StaticInterior,  "hbigkong1t.dis");
ME::RegisterObject( "Temperate Shapes", "Kong Tower 2",          ME::CreateObject, hbigkong2t,	       StaticInterior,  "hbigkong2t.dis");
ME::RegisterObject( "Temperate Shapes", "Kong Tower 3",          ME::CreateObject, hbigkong3t,	       StaticInterior,  "hbigkong3t.dis");
ME::RegisterObject( "Temperate Shapes", "Kong Tower 4",          ME::CreateObject, hbigkong4t,	       StaticInterior,  "hbigkong4t.dis");
ME::RegisterObject( "Temperate Shapes", "Kong Tower 5",          ME::CreateObject, hbigkong5t,	       StaticInterior,  "hbigkong5t.dis");
ME::RegisterObject( "Temperate Shapes", "Kong Tower 6",          ME::CreateObject, hbigkong6t,	       StaticInterior,  "hbigkong6t.dis");
ME::RegisterObject( "Temperate Shapes", "Kong Tower 7",          ME::CreateObject, hbigkong7t,	       StaticInterior,  "hbigkong7t.dis");
ME::RegisterObject( "Temperate Shapes", "Kong Hide",             ME::CreateObject, hkonghidet,	       StaticInterior,  "hkonghide.dis");
ME::RegisterObject( "Temperate Shapes", "Kong Hide2",            ME::CreateObject, hkonghide2t,	   StaticInterior,  "hkonghide2.dis");
ME::RegisterObject( "Temperate Shapes", $separator );
ME::RegisterObject( "Temperate Shapes", "Temperate Rock1",          ME::CreateObject, xtemperaterock1,       StaticShape, "xtemperaterock01.dts" );
ME::RegisterObject( "Temperate Shapes", "Temperate Rock2",          ME::CreateObject, xtemperaterock2,       StaticShape, "xtemperaterock02.dts" );
ME::RegisterObject( "Temperate Shapes", "Temperate Rock3",          ME::CreateObject, xtemperaterock3,       StaticShape, "xtemperaterock03.dts" );
ME::RegisterObject( "Temperate Shapes", "Buddha Statue", 	 ME::CreateObject, hKongBuddha, 	 StaticShape, true, "hKongBuddha.dts");


#---TITAN SHAPES-------------
ME::RegisterObject ( "Titan Shapes", "Titan Rock1",               ME::CreateObject, xtitanrock1,       StaticShape, false,"xtitanrock01.dts" );
ME::RegisterObject ( "Titan Shapes", "Titan Rock2",               ME::CreateObject, xtitanrock2,       StaticShape, false,"xtitanrock02.dts" );
ME::RegisterObject ( "Titan Shapes", "Titan Rock3",               ME::CreateObject, xtitanrock3,       StaticShape, false,"xtitanrock03.dts" );
ME::RegisterObject ("Titan Shapes",  "Titan Bigdish",             ME::CreateObject, hTitanbigdish,     StaticShape, true, "hTitanbigdish.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Gather",              ME::CreateObject, hTitangather,      StaticShape, true, "hTitangather.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Listen",     	  ME::CreateObject, hTitanlisten,         StaticShape, true, "hTitanlisten.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Power",               ME::CreateObject, hTitanpower,       StaticShape, true, "hTitanpower.DTS");
ME::RegisterObject( "Titan Shapes",  "Titan Microwave",           ME::CreateObject, hTitanMicrowave,    StaticShape, true,  "hTitanMicrowave.dts" );
ME::RegisterObject ("Titan Shapes",  "Titan Refinery",            ME::CreateObject, hTitanrefinery,    StaticShape, true, "hTitanrefinery.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Residence",           ME::CreateObject, hTitanresidence,   StaticShape, true, "hTitanresidence.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Silos",     	  ME::CreateObject, hTitansilos,          StaticShape, true, "hTitansilos.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Uplink",              ME::CreateObject, hTitanuplink,      StaticShape, true, "hTitanuplink.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Wall",     	          ME::CreateObject, hTitanwall,        StaticShape, false,"hTitanwall.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Wallcap",             ME::CreateObject, hTitanwallcap,     StaticShape, false,"hTitanwallcap.DTS");
ME::RegisterObject ("Titan Shapes",  "Titan Walldoor",            ME::CreateObject, hTitanwalldoor,    StaticShape, false,"hTitanwalldoor.DTS");
ME::RegisterObject ("Titan Shapes", $separator);
ME::RegisterObject ("Titan Shapes", "Titan Trooper Com",          ME::CreateObject, hTitantroopercom,  StaticShape, true, "hTitantroopercom.DTS");
ME::RegisterObject ("Titan Shapes", "Titan Trooper Command",      ME::CreateObject, hTitancommand,  	StaticShape, true, "hTitancommand.DTS");
ME::RegisterObject ("Titan Shapes", "Titan Trooper HQ",    	  ME::CreateObject, hTitantrooperhq,   StaticShape, true, "hTitantrooperhq.DTS");
ME::RegisterObject ("Titan Shapes", "Titan Trooper Residence",    ME::CreateObject, hTitantrooperresidenc,     StaticShape, true, "hTitantrooperresidence.DTS");
ME::RegisterObject ("Titan Shapes", "Titan Trooper Silos",        ME::CreateObject, hTitantroopsilos,  StaticShape, true, "hTitantroopsilos.DTS");
ME::RegisterObject ("Titan Shapes", "Titan Trooper Storage",        ME::CreateObject, hTitantrooperstorage,  StaticShape, true, "hTitantrooperstorage.DTS");
ME::RegisterObject ("Titan Shapes", "Titan Beam",                 ME::CreateObject, hTitanBeam,        StaticShape, true, "hTitanBEAM.DTS");
ME::RegisterObject ("Titan Shapes", "Titan Dias Irae",            ME::CreateObject, hTitanDiasIrae,    StaticShape, true, "hTitanDiasIrae.DTS");
ME::RegisterObject ("Titan Shapes", $separator);
ME::RegisterObject ("Titan Shapes", "Health Pad",    	          ME::CreateObject, hhealt,    	        StaticInterior,  "hhealt.dis");
ME::RegisterObject ("Titan Shapes", "Ammo Pad",    	          ME::CreateObject, hammot,    	        StaticInterior,  "hammot.dis");
ME::RegisterObject( "Titan Shapes", "Trooper Hanger (ZED)",	  ME::CreateObject, hTroophouseE,	    StaticInterior,  "hTroophouseE.dis" );
ME::RegisterObject ("Titan Shapes", $separator);
ME::RegisterObject ("Titan Shapes", "Titan Research",            ME::CreateObject, hTitanresearch,   StaticShape, true, "hTitanresidence.DTS");

#---VENUS SHAPES-----------
ME::RegisterObject( "Venus Shapes", "Venus Array",               ME::CreateObject, hVenusarray,        StaticShape, true, "hVenusarray.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Arbor",               ME::CreateObject, hVenusarbor,        StaticShape, true,  "hVenusArbor.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Bigdish",             ME::CreateObject, hVenusbigdish,      StaticShape, true, "hVenusbigdish.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Com",                 ME::CreateObject, hVenuscom,          StaticShape, true, "hVenuscom.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Converter1",          ME::CreateObject, hVenusconverter1,   StaticShape, true, "hVenusconverter1.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Converter2",          ME::CreateObject, hVenusconverter2,   StaticShape, true, "hVenusconverter2.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Converter3",          ME::CreateObject, hVenusconverter3,   StaticShape, true, "hVenusconverter3.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Dispertion",          ME::CreateObject, hVenusdispertion,   StaticShape, true, "hVenusdispertion.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Drill",               ME::CreateObject, hVenusdrill,        StaticShape, true, "hVenusdrill.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Eternal Flame",       ME::CreateObject, hVenusEternalFlame, StaticShape, true, "hVenusEternalFlame.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Garage",              ME::CreateObject, hVenusgarage,       StaticShape, true, "hVenusgarage.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Gathering",           ME::CreateObject, hVenusgathering,    StaticShape, true, "hVenusgathering.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Geotherm",            ME::CreateObject, hVenusgeotherm,     StaticShape, true, "hVenusgeotherm.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Lightrod",            ME::CreateObject, hVenuslightrod,     StaticShape, true, "hVenuslightrod.dts" );
ME::RegisterObject( "Venus Shapes", "Venus listening",           ME::CreateObject, hVenuslistening,    StaticShape, true, "hVenuslistening.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Microwave",           ME::CreateObject, hVenusMicrowave,    StaticShape, true,  "hVenusMicrowave.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Perimwall",           ME::CreateObject, hVenusperimwall,    StaticShape, false,"hVenusperimwall.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Refinery",            ME::CreateObject, hVenusrefinery,     StaticShape, true, "hVenusrefinery.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Small Garage",        ME::CreateObject, hVenussmgarage,     StaticShape, true, "hVenussmgarage.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Small Wall",          ME::CreateObject, hVenussmwall,       StaticShape, false,"hVenussmwall.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Storage",             ME::CreateObject, hVenusstorage,      StaticShape, true, "hVenusstorage.dts" );
ME::RegisterObject( "Venus Shapes", "Venus TR HQ",               ME::CreateObject, hVenustrhq,         StaticShape, true, "hVenustrhq.dts" );
ME::RegisterObject( "Venus Shapes", "Venus TR Link",             ME::CreateObject, hVenustrlink,       StaticShape, true, "hVenustrlink.dts" );
ME::RegisterObject( "Venus Shapes", $separator );
ME::RegisterObject( "Venus Shapes", "Venus Rock1",               ME::CreateObject, xvenusrock1,        StaticShape, false,"xvenusrock01.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Rock2",               ME::CreateObject, xvenusrock2,        StaticShape, false,"xvenusrock02.dts" );
ME::RegisterObject( "Venus Shapes", "Venus Rock3",               ME::CreateObject, xvenusrock3,        StaticShape, false,"xvenusrock03.dts" );
#---Venus Interior Shapes------------
ME::RegisterObject( "Venus Interior Shapes", "Bridge        (ZED)",   ME::CreateObject, hbridgev,           StaticInterior, "hbridgev.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Convertor     (ZED)",   ME::CreateObject, hconv,              StaticInterior, "hconv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Small Bridge  (ZED)",   ME::CreateObject, hsmlbridgev,        StaticInterior, "hsmlbridgev.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Small Lift    (ZED)",   ME::CreateObject, hsmliftv,           StaticInterior, "hsmliftv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Small Oil Rig (ZED)",   ME::CreateObject, hsmloilv,           StaticInterior, "hsmloilv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Landing Pad   (ZED)",   ME::CreateObject, hlandpadv,          StaticInterior, "hlandpadv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Large Lift    (ZED)",   ME::CreateObject, hlgliftv,           StaticInterior, "hlgliftv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Large Oil Rig (ZED)",   ME::CreateObject, hlgoilv,            StaticInterior, "hlgoilv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Med Oil Rig   (ZED)",   ME::CreateObject, hmidoilv,           StaticInterior, "hmidoilv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Hub           (ZED)",   ME::CreateObject, hhubv,              StaticInterior, "hhubv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Heal          (ZED)",   ME::CreateObject, hhealv,             StaticInterior, "hhealv.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Ammo          (ZED)",   ME::CreateObject, hammov,             StaticInterior, "hammov.dis" );
ME::RegisterObject( "Venus Interior Shapes", "Monument      (ZED)",   ME::CreateObject, hmonumentv,         StaticInterior, "hmonumentv.dis" );
ME::RegisterObject( "Venus Shapes", $separator );
ME::RegisterObject( "Venus Shapes","Venus Bigdish Dmg",			ME::CreateObject, hVenusbigdish_damaged,		StaticShape, true, "hVenusbigdish_damaged.DTS");
ME::RegisterObject( "Venus Shapes","Venus Converter1 Dmg",		ME::CreateObject, hVenusconverter1_damaged,	StaticShape, true, "hVenusconverter1_damaged.DTS");
ME::RegisterObject( "Venus Shapes","Venus Converter2 Dmg",		ME::CreateObject, hVenusconverter2_damaged,	StaticShape, true, "hVenusconverter2_damaged.DTS");
ME::RegisterObject( "Venus Shapes","Venus Dispertion Dmg",		ME::CreateObject, hVenusdispertion_damaged,	StaticShape, true, "hVenusdispertion_damaged.DTS");
ME::RegisterObject( "Venus Interior Shapes","Hub Ruin (ZED)",				ME::CreateObject, hhubruin1v, 				StaticInterior, "hhubruin1v.dis");
ME::RegisterObject( "Venus Interior Shapes","Large Oil Rig Ruin (ZED)",				ME::CreateObject, hlgoilruin1v, 			StaticInterior, "hlgoilruin1v.dis");
ME::RegisterObject( "Venus Interior Shapes","Small Bridge Ruin (ZED)",			ME::CreateObject, hsmlbridgeruin1v, 			StaticInterior, "hsmlbridgeruin1v.dis");
ME::RegisterObject( "Venus Interior Shapes","Bridge Ruin  (ZED)",			ME::CreateObject, hbridgeruin1v, 			StaticInterior, "hbridgeruin1v.dis");
ME::RegisterObject( "Venus Interior Shapes","Bridge Ruin2 (ZED)",			ME::CreateObject, hbridgeruin2v, 			StaticInterior, "hbridgeruin2v.dis");
ME::RegisterObject( "Venus Interior Shapes","Venus Bridge (ZED)",				ME::CreateObject, hBridgeV, 				StaticInterior, "hBridgeV.dis");
ME::RegisterObject( "Venus Interior Shapes","Convertor Ruin (ZED)",				ME::CreateObject, hconruin1v, 			StaticInterior, "hconruin1v.dis");

#--------------------------------------------------------------------------------------------------------------------------------
ME::RegisterObject( $separator );


#----GENERIC SHAPES
ME::RegisterObject( "Generic Shapes", "Boxes",                 ME::CreateObject, xBoxes,            StaticShape, true, "xBoxes.dts");
ME::RegisterObject( "Generic Shapes", "Container",             ME::CreateObject, xContainer,        StaticShape, true, "xContainer.dts");
ME::RegisterObject( "Generic Shapes", "Fuel Tank",             ME::CreateObject, xfueltank,         StaticShape, true, "xFuelTank.dts");
ME::RegisterObject( "Generic Shapes", "Human Drop Pod",        ME::CreateObject, hDropPod,          StaticShape, true, "hDropPod.dts");
ME::RegisterObject( "Generic Shapes", "Monument",              ME::CreateObject, xMonument,         StaticShape, true, "xMonument.dts");
ME::RegisterObject( "Generic Shapes", "Target Drone",          ME::CreateObject, xObstacle,         StaticShape, true, "xobstacle.dts");
ME::RegisterObject( "Generic Shapes", "Trooper Container",     ME::CreateObject, xtroopercontainer, StaticShape, true, "xtroopercontainer.dts");
ME::RegisterObject( "Generic Shapes", $separator );
ME::RegisterObject( "Generic Shapes", "BridgeHub1 (ZED)",          ME::CreateObject, xbridgehub,         StaticInterior, "xbridgehub.dis");
ME::RegisterObject( "Generic Shapes", "BridgeHub2 (ZED)",          ME::CreateObject, xbridgehub2,        StaticInterior, "xbridgehub2.dis");
ME::RegisterObject( "Generic Shapes", "BridgeHub3 (ZED)",          ME::CreateObject, xbridgehub3,        StaticInterior, "xbridgehub3.dis");
ME::RegisterObject( "Generic Shapes", "BridgeHub4 (ZED)",          ME::CreateObject, xbridgehub4,        StaticInterior, "xbridgehub4.dis");
ME::RegisterObject( "Generic Shapes", $separator);
ME::RegisterObject( "Generic Shapes", "Yellow Flag",          ME::CreateObject, yellowFlag,       StaticShape, "team1.dts" );
ME::RegisterObject( "Generic Shapes", "Blue Flag",            ME::CreateObject, blueFlag,         StaticShape, "team2.dts" );
ME::RegisterObject( "Generic Shapes", "Red Flag",             ME::CreateObject, readFlag,         StaticShape, "team3.dts" );
ME::RegisterObject( "Generic Shapes", "Purple Flag",          ME::CreateObject, purpleFlag,       StaticShape, "team4.dts" );
ME::RegisterObject( "Generic Shapes", "Cryo Door",            ME::CreateObject, xCryodDoor,       StaticShape, "xCryodoor.dts" );
ME::RegisterObject( "Generic Shapes", $separator );
ME::RegisterObject( "Generic Shapes", "Movie House (ZED)",    ME::CreateObject, hmovie,           StaticInterior, "hmovie.dis" );
ME::RegisterObject( "Generic Shapes", $separator );
ME::RegisterObject( "Generic Shapes", "Tower 1(ZED)",          ME::CreateObject, hhugescraper1,	       StaticInterior,  "hhugescraper1.dis");
ME::RegisterObject( "Generic Shapes", "Tower 2(ZED)",          ME::CreateObject, hhugescraper2,	       StaticInterior,  "hhugescraper2.dis");
ME::RegisterObject( "Generic Shapes", "Tower 3(ZED)",          ME::CreateObject, hhugescraper3,	       StaticInterior,  "hhugescraper3.dis");
ME::RegisterObject( "Generic Shapes", "Tower 4(ZED)",          ME::CreateObject, hhugescraper4,	       StaticInterior,  "hhugescraper4.dis");
ME::RegisterObject( "Generic Shapes", "Tower 5(ZED)",          ME::CreateObject, hhugescraper5,	       StaticInterior,  "hhugescraper5.dis");
ME::RegisterObject( "Generic Shapes", "Tower 6(ZED)",          ME::CreateObject, hhugescraper6,	       StaticInterior,  "hhugescraper6.dis");
ME::RegisterObject( "Generic Shapes", "Tower 7(ZED)",          ME::CreateObject, hhugescraper7,	       StaticInterior,  "hhugescraper7.dis");
ME::RegisterObject( "Generic Shapes", "Tower 8(ZED)",          ME::CreateObject, hhugescraper8,	       StaticInterior,  "hhugescraper8.dis");
ME::RegisterObject( "Generic Shapes", $separator );
ME::RegisterObject( "Generic Shapes", "Big Trooper Container",          ME::CreateObject, xBigTrooperContainer,        		StaticShape, true, "xBigTrooperContainer.dts");
ME::RegisterObject( "Generic Shapes", "Drive In", 			ME::CreateObject, Drive_IN, 					StaticShape, true, "Drive_IN.DTS");
ME::RegisterObject( "Generic Shapes", "Flagbuilding 1(ZED)",		ME::CreateObject, hflagbuild, 	StaticInterior, "hflagbuild.dis");
ME::RegisterObject( "Generic Shapes", "Flagbuilding 2(ZED)",		ME::CreateObject, hflagbuild2, 	StaticInterior, "hflagbuild2.dis");
ME::RegisterObject( "Generic Shapes", "Trevtest(ZED)",			ME::CreateObject, trevtest, 		StaticInterior, "trevtest.dis");
ME::RegisterObject( "Generic Shapes", "Herc Pad",			ME::CreateObject, herc_pad, 		StaticShape, true, "herc_pad.DTS");

#----Heal/Ammo SHAPES
ME::RegisterObject( "Heal/Ammo Shapes", "Heal Lite",       ME::CreateObject, xheal_lite,          StaticShape, true, "xheal_lite.dts");
ME::RegisterObject( "Heal/Ammo Shapes", "Heal Dark",       ME::CreateObject, xheal_dark,          StaticShape, true, "xheal_dark.dts");
ME::RegisterObject( "Heal/Ammo Shapes", "Heal Venus",      ME::CreateObject, xheal_venus,         StaticShape, true, "xheal_venus.dts");
ME::RegisterObject( "Heal/Ammo Shapes", "Ammo Lite",       ME::CreateObject, xammo_lite,          StaticShape, true, "xammo_lite.dts");
ME::RegisterObject( "Heal/Ammo Shapes", "Ammo Dark",       ME::CreateObject, xammo_dark,          StaticShape, true, "xammo_dark.dts");
ME::RegisterObject( "Heal/Ammo Shapes", "Ammo Venus",      ME::CreateObject, xammo_venus,         StaticShape, true, "xammo_venus.dts");
ME::RegisterObject( "Heal/Ammo Shapes", "ZenAll Lite",     ME::CreateObject, xzen_lite,           StaticShape, true, "xzen_lite.dts");
ME::RegisterObject( "Heal/Ammo Shapes", "ZenAll Dark",     ME::CreateObject, xzen_dark,           StaticShape, true, "xzen_dark.dts");
ME::RegisterObject( "Heal/Ammo Shapes", $separator );
ME::RegisterObject( "Heal/Ammo Shapes", "Heal Lite (ZED)", 	ME::CreateObject, hHeallite,           StaticInterior, "hHeallite.dis");
ME::RegisterObject( "Heal/Ammo Shapes", "Heal Dark (ZED)", 	ME::CreateObject, hHealdark,           StaticInterior, "hHealdark.dis");
ME::RegisterObject( "Heal/Ammo Shapes", "Heal Venus(ZED)", 	ME::CreateObject, hHealvenus,          StaticInterior, "hHealvenus.dis");
ME::RegisterObject( "Heal/Ammo Shapes", "Ammo Lite (ZED)", 	ME::CreateObject, hAmmolite,           StaticInterior, "hAmmolite.dis");
ME::RegisterObject( "Heal/Ammo Shapes", "Ammo Dark (ZED)", 	ME::CreateObject, hAmmodark,           StaticInterior, "hAmmodark.dis");
ME::RegisterObject( "Heal/Ammo Shapes", "Ammo Venus(ZED)", 	ME::CreateObject, hAmmovenus,          StaticInterior, "hAmmovenus.dis");
ME::RegisterObject( "Heal/Ammo Shapes", "ZenAll Lite (ZED)", 	ME::CreateObject, hZenlite,           StaticInterior, "hZenlite.dis");
ME::RegisterObject( "Heal/Ammo Shapes", "ZenAll Dark (ZED)", 	ME::CreateObject, hZendark,           StaticInterior, "hZendark.dis");

#----Multiplayer SHAPES
ME::RegisterObject( "Multiplayer Shapes", "Low-Poly Monument",    	ME::CreateObject, hLPMonument,        StaticShape,    "xMonument_LOW.dts");
ME::RegisterObject( "Multiplayer Shapes", $separator );
ME::RegisterObject( "Multiplayer Shapes", "Football Uprights (ZED)",   	ME::CreateObject, football,   StaticInterior,   "football.dis");
ME::RegisterObject( "Multiplayer Shapes", "Teleporter (ZED)",    	ME::CreateObject, teleport,         StaticInterior,   "teleport.dis");
ME::RegisterObject( "Multiplayer Shapes", "Teleporter Effect",   	ME::CreateObject, fx_tele_t,        StaticShape, true, "fx_tele_t.dts");

#Cinematic Shapes
ME::RegisterObject("Cinematic Shapes",	"Cybrid Spaceship Big", 	ME::CreateObject, cyspacbg, 	StaticShape, true, "cy_spac.DTS");
ME::RegisterObject("Cinematic Shapes",	"Cybrid Spaceship Small", 	ME::CreateObject, cyspacsm, 	StaticShape, true, "cin_cyspac.DTS");
ME::RegisterObject("Cinematic Shapes",	"Cybrid Spaceship Small2", 	ME::CreateObject, cyspacs2, 	StaticShape, true, "cin_cyspacsm.DTS");
ME::RegisterObject("Cinematic Shapes",	"Caanon Standing", 		ME::CreateObject, caanonp, 	StaticShape, true, "cin_caanon.DTS");
ME::RegisterObject("Cinematic Shapes",	"Terran Spaceship Big", 	ME::CreateObject, trspacbg, 	StaticShape, true, "tr_spac.DTS");
ME::RegisterObject("Cinematic Shapes",	"Small Terran Spaceship", 	ME::CreateObject, smltrspc, 	StaticShape, true, "cin_spac.DTS");
ME::RegisterObject("Cinematic Shapes", 	$separator );
ME::RegisterObject("Cinematic Shapes",	"Earth", 	ME::CreateObject, earth, 	StaticShape, true, "cin_earth.DTS");
ME::RegisterObject("Cinematic Shapes",	"Moon", 	ME::CreateObject, moon, 	StaticShape, true, "cin_moon.DTS");
ME::RegisterObject("Cinematic Shapes",	"Mars", 	ME::CreateObject, mars, 	StaticShape, true, "cin_mars.DTS");
ME::RegisterObject("Cinematic Shapes",	"Titan", 	ME::CreateObject, titan, 	StaticShape, true, "cin_titan.DTS");
ME::RegisterObject("Cinematic Shapes",	"Saturn", 	ME::CreateObject, saturn, 	StaticShape, true, "cin_saturn.DTS");
ME::RegisterObject("Cinematic Shapes",	"Pluto", 	ME::CreateObject, pluto, 	StaticShape, true, "cin_pluto.DTS");
ME::RegisterObject("Cinematic Shapes",	"Mercury", 	ME::CreateObject, mercury, 	StaticShape, true, "cin_merc.DTS");
ME::RegisterObject("Cinematic Shapes",	"Venus", 	ME::CreateObject, venus, 	StaticShape, true, "cin_venus.DTS");
ME::RegisterObject("Cinematic Shapes", 	$separator );
ME::RegisterObject("Cinematic Shapes",	"Special Mine", 		ME::CreateObject, cinmine, 			StaticShape, true, "cin_mine.DTS");
ME::RegisterObject("Cinematic Shapes", 	"Mars(only)Cache",          	ME::CreateObject, mwarehouse,	       	StaticInterior,  "mwarehouse.dis");
ME::RegisterObject("Cinematic Shapes",	"Landing Gear Banshee", 	ME::CreateObject, cinbans, 			StaticShape, true, "cin_bans.DTS");
ME::RegisterObject("Cinematic Shapes",	"Cyro People", 			ME::CreateObject, corcyro, 			StaticShape, true, "cin_cryo.DTS");
ME::RegisterObject("Cinematic Shapes",	"Escape", 	ME::CreateObject, escape, 	StaticShape, true, "cin_escape.DTS");
ME::RegisterObject("Cinematic Shapes",	"Fire", 	ME::CreateObject, cinfire, 	StaticShape, true, "cin_fire.DTS");
ME::RegisterObject("Cinematic Shapes",	"Beam", 	ME::CreateObject, cinbeam, 	StaticShape, true, "cin_beam.DTS");
ME::RegisterObject("Cinematic Shapes",	"Astro", 	ME::CreateObject, astro, 	StaticShape, true, "cin_astro1.DTS");
ME::RegisterObject("Cinematic Shapes",	"Drop", 	ME::CreateObject, drop001, 	StaticShape, true, "cin_drop.DTS");
ME::RegisterObject("Cinematic Shapes",	"Drop1", 	ME::CreateObject, drop002, 	StaticShape, true, "cin_drop1.DTS");
ME::RegisterObject("Cinematic Shapes",	"Drop2", 	ME::CreateObject, drop003, 	StaticShape, true, "cin_drop2.DTS");
ME::RegisterObject("Cinematic Shapes",	"Drop3", 	ME::CreateObject, drop004, 	StaticShape, true, "cin_drop3.DTS");
ME::RegisterObject("Cinematic Shapes", $separator );
ME::RegisterObject("Cinematic Shapes","Tree1", 		ME::CreateObject, tree1, StaticShape, true, "xTree.DTS");
ME::RegisterObject("Cinematic Shapes","Tree2", 		ME::CreateObject, tree2, StaticShape, true, "xtree02.DTS");
ME::RegisterObject("Cinematic Shapes","Tree3", 		ME::CreateObject, tree3, StaticShape, true, "xtree03.DTS");
ME::RegisterObject("Cinematic Shapes","Tree4", 		ME::CreateObject, tree4, StaticShape, true, "xtree04.DTS");
ME::RegisterObject("Cinematic Shapes","Tree5", 		ME::CreateObject, tree5, StaticShape, true, "xTree1.DTS");
ME::RegisterObject("Cinematic Shapes","Tree6", 		ME::CreateObject, tree6, StaticShape, true, "xTree2.DTS");
ME::RegisterObject("Cinematic Shapes","Tree7", 		ME::CreateObject, tree7, StaticShape, true, "xTree3.DTS");
ME::RegisterObject("Cinematic Shapes","Tree8", 		ME::CreateObject, tree8, StaticShape, true, "xsnowtree.DTS");
ME::RegisterObject("Cinematic Shapes","Tree9", 		ME::CreateObject, tree9, StaticShape, true, "xsnowtreetwo.DTS");
ME::RegisterObject("Cinematic Shapes", $separator );
ME::RegisterObject("Cinematic Shapes","cin_baslempty", 		ME::CreateObject, cin_baslempty, 	StaticShape, true, "cin_baslempty.DTS");
ME::RegisterObject("Cinematic Shapes","cin_baslhb", 		ME::CreateObject, cin_baslhb, 		StaticShape, true, "cin_baslhb.DTS");
ME::RegisterObject("Cinematic Shapes","cin_baslhb2", 		ME::CreateObject, cin_baslhb2, 		StaticShape, true, "cin_baslhb2.DTS");
ME::RegisterObject("Cinematic Shapes","cin_cydrop", 		ME::CreateObject, cin_cydrop, 		StaticShape, true, "cin_cydrop.DTS");
ME::RegisterObject("Cinematic Shapes","cin_cydrop2", 		ME::CreateObject, cin_cydrop2, 		StaticShape, true, "cin_cydrop2.DTS");
ME::RegisterObject("Cinematic Shapes","cy_pod", 		ME::CreateObject, cy_pod, 		StaticShape, true, "cy_pod.DTS");

#Special Effects Shapes

ME::RegisterObject("FX Shapes","Bans_ex", 	ME::CreateObject, fx2, StaticShape, true, "fx_bans_exh.DTS");
ME::RegisterObject("FX Shapes","Bans_ex2 trans", 	ME::CreateObject, fx3, StaticShape, true, "fx_bans_exhT.DTS");
ME::RegisterObject("FX Shapes","Carg Exh", 	ME::CreateObject, fx4, StaticShape, true, "fx_CARG_EXH.DTS");
ME::RegisterObject("FX Shapes","Carg_Exh2 trans", 	ME::CreateObject, fx5, StaticShape, true, "fx_CARG_EXH_T.DTS");
ME::RegisterObject("FX Shapes","Conv_exh", 	ME::CreateObject, fx6, StaticShape, true, "fx_conv_exh.DTS");
ME::RegisterObject("FX Shapes","Conv_exh2 trans", 	ME::CreateObject, fx7, StaticShape, true, "fx_conv_exhT.DTS");
ME::RegisterObject("FX Shapes","Cydrop_exh", 	ME::CreateObject, fx8, StaticShape, true, "fx_cydrop_exh.DTS");
ME::RegisterObject("FX Shapes","Cydrop_exh2 trans", 	ME::CreateObject, fx9, StaticShape, true, "fx_cydrop_exhT.DTS");
ME::RegisterObject("FX Shapes","Cypod", 	ME::CreateObject, fx11, StaticShape, true, "fx_cypod.DTS");
ME::RegisterObject("FX Shapes","Cypod2 trans", 	ME::CreateObject, fx22, StaticShape, true, "fx_cypodT.DTS");
ME::RegisterObject("FX Shapes","Cypodfar", 	ME::CreateObject, fx33, StaticShape, true, "fx_cypod_far.DTS");
ME::RegisterObject("FX Shapes","Cypodfar2 trans", 	ME::CreateObject, fx44, StaticShape, true, "fx_cypod_farT.DTS");
ME::RegisterObject("FX Shapes","Drop trans", 		ME::CreateObject, fx55, StaticShape, true, "fx_dropT.DTS");
ME::RegisterObject("FX Shapes","Drop_exh", 	ME::CreateObject, fx66, StaticShape, true, "fx_drop_exh.DTS");
ME::RegisterObject("FX Shapes","Drop_exh2 trans", 	ME::CreateObject, fx77, StaticShape, true, "fx_drop_exhT.DTS");
ME::RegisterObject("FX Shapes","Dust", 		ME::CreateObject, fx88, StaticShape, true, "fx_dust.DTS");
ME::RegisterObject("FX Shapes","Dust2", 	ME::CreateObject, fx99, StaticShape, true, "fx_dust_bl.DTS");
ME::RegisterObject("FX Shapes","Dust3", 	ME::CreateObject, fx111, StaticShape, true, "fx_dust_br.DTS");
ME::RegisterObject("FX Shapes","Dust4", 	ME::CreateObject, fx222, StaticShape, true, "fx_dust_dbr.DTS");
ME::RegisterObject("FX Shapes","Dust5", 	ME::CreateObject, fx333, StaticShape, true, "fx_dust_dor.DTS");
ME::RegisterObject("FX Shapes","Dust6", 	ME::CreateObject, fx444, StaticShape, true, "fx_dust_dyl.DTS");
ME::RegisterObject("FX Shapes","Dust7", 	ME::CreateObject, fx555, StaticShape, true, "fx_dust_gr.DTS");
ME::RegisterObject("FX Shapes","Dust8", 	ME::CreateObject, fx666, StaticShape, true, "fx_dust_lbl.DTS");
ME::RegisterObject("FX Shapes","Dust9", 	ME::CreateObject, fx777, StaticShape, true, "fx_dust_lgr.DTS");
ME::RegisterObject("FX Shapes","Dust10", 	ME::CreateObject, fx888, StaticShape, true, "fx_dust_or.DTS");
ME::RegisterObject("FX Shapes","Dust11", 	ME::CreateObject, fx999, StaticShape, true, "fx_dust_yl.DTS");
ME::RegisterObject("FX Shapes","Elec", 		ME::CreateObject, fx1111, StaticShape, true, "fx_elec.DTS");
ME::RegisterObject("FX Shapes","Elec2 trans", 	ME::CreateObject, fx2222, StaticShape, true, "fx_elec_T.DTS");
ME::RegisterObject("FX Shapes","Escape_ex", 	ME::CreateObject, fx3333, StaticShape, true, "fx_ESCAPE_EXH.DTS");
ME::RegisterObject("FX Shapes","Excape_ex2 trans", 	ME::CreateObject, fx4444, StaticShape, true, "fx_ESCAPE_EXH_T.DTS");
ME::RegisterObject("FX Shapes","Exhaust", 		ME::CreateObject, fx5555, StaticShape, true, "fx_exhaust.DTS");
ME::RegisterObject("FX Shapes","Explosion", 		ME::CreateObject, fx6666, StaticShape, true, "fx_exp_lg.DTS");
ME::RegisterObject("FX Shapes","Explosion2 trans", 	ME::CreateObject, fx7777, StaticShape, true, "fx_exp_lgT.DTS");
ME::RegisterObject("FX Shapes","Med Explosion", 	ME::CreateObject, fx8888, StaticShape, true, "fx_exp_md.DTS");
ME::RegisterObject("FX Shapes","Med Explosion2 trans", 	ME::CreateObject, fx9999, StaticShape, true, "fx_exp_mdT.DTS");
ME::RegisterObject("FX Shapes","Pod Explosion", 	ME::CreateObject, fx11111, StaticShape, true, "fx_exp_pod.DTS");
ME::RegisterObject("FX Shapes","Pod Explosion2 trans", 	ME::CreateObject, fx22222, StaticShape, true, "fx_exp_podT.DTS");
ME::RegisterObject("FX Shapes","Sm Explosion", 		ME::CreateObject, fx75500745, StaticShape, true, "fx_exp_sm.DTS");
ME::RegisterObject("FX Shapes","Sm Explosion2 trans", 	ME::CreateObject, fx457456300, StaticShape, true, "fx_exp_smT.DTS");
ME::RegisterObject("FX Shapes","Fball", 		ME::CreateObject, fx33333, StaticShape, true, "fx_fball_md.DTS");
ME::RegisterObject("FX Shapes","Fball2 trans", 		ME::CreateObject, fx44444, StaticShape, true, "fx_fball_mdT.DTS");
ME::RegisterObject("FX Shapes","Fball3", 		ME::CreateObject, fx55555, StaticShape, true, "fx_fball_sm.DTS");
ME::RegisterObject("FX Shapes","Fball4 trans", 		ME::CreateObject, fx66666, StaticShape, true, "fx_fball_smT.DTS");
ME::RegisterObject("FX Shapes","Large Flame", 		ME::CreateObject, fx77777, StaticShape, true, "fx_flame_lg.DTS");
ME::RegisterObject("FX Shapes","Large Flame2 trans", 	ME::CreateObject, fx88888, StaticShape, true, "fx_flame_lgT.DTS");
ME::RegisterObject("FX Shapes","Med Flame", 		ME::CreateObject, fx99999, StaticShape, true, "fx_flame_md.DTS");
ME::RegisterObject("FX Shapes","Med Flame2 trans", 	ME::CreateObject, fx12, StaticShape, true, "fx_flame_mdT.DTS");
ME::RegisterObject("FX Shapes","Small Flame", 		ME::CreateObject, fx13, StaticShape, true, "fx_flame_sm.DTS");
ME::RegisterObject("FX Shapes","Small Flame2 trans", 	ME::CreateObject, fx14, StaticShape, true, "fx_flame_smT.DTS");
ME::RegisterObject("FX Shapes","Imp_fb", 		ME::CreateObject, fx15, StaticShape, true, "fx_imp_fb.DTS");
ME::RegisterObject("FX Shapes","Imp_fb2 trans", 	ME::CreateObject, fx21, StaticShape, true, "fx_imp_fbT.DTS");
ME::RegisterObject("FX Shapes","Imp_md", 		ME::CreateObject, fx23, StaticShape, true, "fx_imp_md.DTS");
ME::RegisterObject("FX Shapes","Imp_md2 trans", 	ME::CreateObject, fx34, StaticShape, true, "fx_imp_mdT.DTS");
ME::RegisterObject("FX Shapes","Imp_sm", 		ME::CreateObject, fx35, StaticShape, true, "fx_imp_sm.DTS");
ME::RegisterObject("FX Shapes","Imp_sm2 trans", 	ME::CreateObject, fx56, StaticShape, true, "fx_imp_smT.DTS");
ME::RegisterObject("FX Shapes","Imp_sp", 		ME::CreateObject, fx73, StaticShape, true, "fx_imp_sp.DTS");
ME::RegisterObject("FX Shapes","Imp_sp2 trans", 	ME::CreateObject, fx37, StaticShape, true, "fx_imp_spT.DTS");
ME::RegisterObject("FX Shapes","Imp_tn", 		ME::CreateObject, fx00, StaticShape, true, "fx_imp_tn.DTS");
ME::RegisterObject("FX Shapes","Imp_tn2 trans", 	ME::CreateObject, fx84, StaticShape, true, "fx_imp_tnT.DTS");
ME::RegisterObject("FX Shapes","Orbeam", 		ME::CreateObject, fx456, StaticShape, true, "fx_orbeam.DTS");
ME::RegisterObject("FX Shapes","Shieldelc", 		ME::CreateObject, fx45, StaticShape, true, "fx_shield_elc.DTS");
ME::RegisterObject("FX Shapes","Shieldelc2 trans", 	ME::CreateObject, fx060, StaticShape, true, "fx_shield_elcT.DTS");
ME::RegisterObject("FX Shapes","Shieldeng", 		ME::CreateObject, fx786, 	StaticShape, true, "fx_shield_eng.DTS");
ME::RegisterObject("FX Shapes","Shieldeng2 trans", 	ME::CreateObject, fx678, 	StaticShape, true, "fx_shield_engT.DTS");
ME::RegisterObject("FX Shapes","Shieldexp", 		ME::CreateObject, fx486, 	StaticShape, true, "fx_shield_exp.DTS");
ME::RegisterObject("FX Shapes","Shieldexp2 trans", 	ME::CreateObject, fx468, 	StaticShape, true, "fx_shield_expT.DTS");
ME::RegisterObject("FX Shapes","Shieldlas", 		ME::CreateObject, fx9990, 	StaticShape, true, "fx_shield_lsr.DTS");
ME::RegisterObject("FX Shapes","Shieldlas2 trans", 	ME::CreateObject, fx536, 	StaticShape, true, "fx_shield_lsrT.DTS");
ME::RegisterObject("FX Shapes","Shieldssr", 		ME::CreateObject, fx3467, 	StaticShape, true, "fx_shield_ssr.DTS");
ME::RegisterObject("FX Shapes","Shieldssr2 trans", 	ME::CreateObject, fx345, 	StaticShape, true, "fx_shield_ssrT.DTS");
ME::RegisterObject("FX Shapes","Shocklg", 		ME::CreateObject, fx435, 	StaticShape, true, "fx_shock_lg.DTS");
ME::RegisterObject("FX Shapes","Shocklg2 trans", 	ME::CreateObject, fx34505, 	StaticShape, true, "fx_shock_lgT.DTS");
ME::RegisterObject("FX Shapes","Shockmd", 		ME::CreateObject, fx36789, 	StaticShape, true, "fx_shock_md.DTS");
ME::RegisterObject("FX Shapes","Shockmd2 trans", 	ME::CreateObject, fx3689, 	StaticShape, true, "fx_shock_mdT.DTS");
ME::RegisterObject("FX Shapes","Shocksm trans", 	ME::CreateObject, fx9357, 	StaticShape, true, "fx_shock_sm.DTS");
ME::RegisterObject("FX Shapes","Shocksm", 		ME::CreateObject, fx65783, 	StaticShape, true, "fx_shock_smT.DTS");
ME::RegisterObject("FX Shapes","Smokelg", 		ME::CreateObject, fx35683, 	StaticShape, true, "fx_smoke_lg.DTS");
ME::RegisterObject("FX Shapes","Smokelg trans2", 	ME::CreateObject, fx36583, 	StaticShape, true, "fx_smoke_lgT.DTS");
ME::RegisterObject("FX Shapes","Smokemd", 		ME::CreateObject, fx34583, 	StaticShape, true, "fx_smoke_md.DTS");
ME::RegisterObject("FX Shapes","Smokemd trans2", 	ME::CreateObject, fx34754, 	StaticShape, true, "fx_smoke_mdT.DTS");
ME::RegisterObject("FX Shapes","Smokesm", 		ME::CreateObject, fx679676, 	StaticShape, true, "fx_smoke_sm.DTS");
ME::RegisterObject("FX Shapes","Smokesm2 trans", 	ME::CreateObject, fx645654, 	StaticShape, true, "fx_smoke_smT.DTS");
ME::RegisterObject("FX Shapes","Smoketr", 		ME::CreateObject, fx846746, 	StaticShape, true, "fx_smoke_tr.DTS");
ME::RegisterObject("FX Shapes","Smoketr2 trans", 	ME::CreateObject, fx546754, 	StaticShape, true, "fx_smoke_trT.DTS");
ME::RegisterObject("FX Shapes","Teleporter trans", 	ME::CreateObject, fx457465, 	StaticShape, true, "fx_Tele_T.DTS");
ME::RegisterObject("FX Shapes","Thumper trans", 	ME::CreateObject, fx456765756, 	StaticShape, true, "fx_thump_T.DTS");

#Weapon Muzzle Flashes

ME::RegisterObject("Weapon Mzs","ATC", 		ME::CreateObject, mz000, StaticShape, true, "mz_atc.DTS");
ME::RegisterObject("Weapon Mzs","ATC2 trans", 	ME::CreateObject, mz001, StaticShape, true, "mz_atcT.DTS");
ME::RegisterObject("Weapon Mzs","BLAS", 	ME::CreateObject, mz002, StaticShape, true, "mz_blas.DTS");
ME::RegisterObject("Weapon Mzs","BLAS2 trans", 	ME::CreateObject, mz003, StaticShape, true, "mz_blasT.DTS");
ME::RegisterObject("Weapon Mzs","blink", 	ME::CreateObject, mz004, StaticShape, true, "mz_blnk.DTS");
ME::RegisterObject("Weapon Mzs","blink2 trans", ME::CreateObject, mz005, StaticShape, true, "mz_blnkT.DTS");
ME::RegisterObject("Weapon Mzs","clas", 	ME::CreateObject, mz006, StaticShape, true, "mz_clas.DTS");
ME::RegisterObject("Weapon Mzs","clas2 trans", 	ME::CreateObject, mz007, StaticShape, true, "mz_clasT.DTS");
ME::RegisterObject("Weapon Mzs","dis", 		ME::CreateObject, mz008, StaticShape, true, "mz_dis.DTS");
ME::RegisterObject("Weapon Mzs","dis2 trans", 	ME::CreateObject, mz009, StaticShape, true, "mz_disT.DTS");
ME::RegisterObject("Weapon Mzs","elf", 		ME::CreateObject, mz010, StaticShape, true, "mz_elf.DTS");
ME::RegisterObject("Weapon Mzs","elf2 trans", 	ME::CreateObject, mz011, StaticShape, true, "mz_elfT.DTS");
ME::RegisterObject("Weapon Mzs","emp", 		ME::CreateObject, mz012, StaticShape, true, "mz_emp.DTS");
ME::RegisterObject("Weapon Mzs","emp2 trans", 	ME::CreateObject, mz013, StaticShape, true, "mz_empT.DTS");
ME::RegisterObject("Weapon Mzs","hatc", 	ME::CreateObject, mz014, StaticShape, true, "mz_hatc.DTS");
ME::RegisterObject("Weapon Mzs","hatc2 trans", 	ME::CreateObject, mz015, StaticShape, true, "mz_hatcT.DTS");
ME::RegisterObject("Weapon Mzs","hbla", 	ME::CreateObject, mz016, StaticShape, true, "mz_hbla.DTS");
ME::RegisterObject("Weapon Mzs","hbla2 trans", 	ME::CreateObject, mz017, StaticShape, true, "mz_hblaT.DTS");
ME::RegisterObject("Weapon Mzs","las", 		ME::CreateObject, mz018, StaticShape, true, "mz_las.DTS");
ME::RegisterObject("Weapon Mzs","las2 trans", 	ME::CreateObject, mz019, StaticShape, true, "mz_lasT.DTS");
ME::RegisterObject("Weapon Mzs","mfac", 	ME::CreateObject, mz020, StaticShape, true, "mz_mfac.DTS");
ME::RegisterObject("Weapon Mzs","mfac2 trans", 	ME::CreateObject, mz021, StaticShape, true, "mz_mfacT.DTS");
ME::RegisterObject("Weapon Mzs","pbw", 		ME::CreateObject, mz022, StaticShape, true, "mz_pbw.DTS");
ME::RegisterObject("Weapon Mzs","pbw2 trans", 	ME::CreateObject, mz023, StaticShape, true, "mz_pbwT.DTS");
ME::RegisterObject("Weapon Mzs","plas", 	ME::CreateObject, mz024, StaticShape, true, "mz_plas.DTS");
ME::RegisterObject("Weapon Mzs","plas2 trans", 	ME::CreateObject, mz025, StaticShape, true, "mz_plasT.DTS");
ME::RegisterObject("Weapon Mzs","rail", 	ME::CreateObject, mz026, StaticShape, true, "mz_rail.DTS");
ME::RegisterObject("Weapon Mzs","rail2 trans", 	ME::CreateObject, mz027, StaticShape, true, "mz_railT.DTS");
ME::RegisterObject("Weapon Mzs","smok", 	ME::CreateObject, mz028, StaticShape, true, "mz_smok.DTS");
ME::RegisterObject("Weapon Mzs","smok2 trans", 	ME::CreateObject, mz029, StaticShape, true, "mz_smokT.DTS");
ME::RegisterObject("Weapon Mzs","tlas", 	ME::CreateObject, mz030, StaticShape, true, "mz_tlas.DTS");
ME::RegisterObject("Weapon Mzs","tlas2 trans", 	ME::CreateObject, mz031, StaticShape, true, "mz_tlas.DTS");

#Projectile Shapes

ME::RegisterObject("Projectiles","Ara", 	ME::CreateObject, pr0, StaticShape, true, "pr_ara.DTS");
ME::RegisterObject("Projectiles","atc", 	ME::CreateObject, pr0, StaticShape, true, "pr_atc.DTS");
ME::RegisterObject("Projectiles","atc2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_atcT.DTS");
ME::RegisterObject("Projectiles","bc", 		ME::CreateObject, pr0, StaticShape, true, "pr_bc.DTS");
ME::RegisterObject("Projectiles","bc2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_bcT.DTS");
ME::RegisterObject("Projectiles","blas", 	ME::CreateObject, pr0, StaticShape, true, "pr_blas.DTS");
ME::RegisterObject("Projectiles","blas2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_blasT.DTS");
ME::RegisterObject("Projectiles","blnk", 	ME::CreateObject, pr0, StaticShape, true, "pr_blnk.DTS");
ME::RegisterObject("Projectiles","blnk2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_blnkT.DTS");
ME::RegisterObject("Projectiles","bull", 	ME::CreateObject, pr0, StaticShape, true, "pr_bull.DTS");
ME::RegisterObject("Projectiles","bull2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_bullT.DTS");
ME::RegisterObject("Projectiles","dis", 	ME::CreateObject, pr0, StaticShape, true, "pr_dis.DTS");
ME::RegisterObject("Projectiles","dis2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_disT.DTS");
ME::RegisterObject("Projectiles","emc", 	ME::CreateObject, pr0, StaticShape, true, "pr_emc.DTS");
ME::RegisterObject("Projectiles","emc2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_emcT.DTS");
ME::RegisterObject("Projectiles","emp", 	ME::CreateObject, pr0, StaticShape, true, "pr_emp.DTS");
ME::RegisterObject("Projectiles","emp2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_empT.DTS"); 
ME::RegisterObject("Projectiles","hatc", 	ME::CreateObject, pr0, StaticShape, true, "pr_hatc.DTS");
ME::RegisterObject("Projectiles","hatc2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_hatcT.DTS");
ME::RegisterObject("Projectiles","hbc", 	ME::CreateObject, pr0, StaticShape, true, "pr_hbc.DTS");
ME::RegisterObject("Projectiles","hbc2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_hbcT.DTS");
ME::RegisterObject("Projectiles","hbla", 	ME::CreateObject, pr0, StaticShape, true, "pr_hbla.DTS");
ME::RegisterObject("Projectiles","hbla2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_hblaT.DTS");
ME::RegisterObject("Projectiles","hshell", 	ME::CreateObject, pr0, StaticShape, true, "pr_hshell.DTS");
ME::RegisterObject("Projectiles","hshell2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_hshellT.DTS");
ME::RegisterObject("Projectiles","mfac", 	ME::CreateObject, pr0, StaticShape, true, "pr_mfac.DTS");
ME::RegisterObject("Projectiles","mfac2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_mfacT.DTS");
ME::RegisterObject("Projectiles","min", 	ME::CreateObject, pr0, StaticShape, true, "pr_min.DTS");
ME::RegisterObject("Projectiles","min2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_minT.DTS");
ME::RegisterObject("Projectiles","misl1", 	ME::CreateObject, pr0, StaticShape, true, "pr_misl1.DTS");
ME::RegisterObject("Projectiles","misl12 trans", ME::CreateObject, pr0, StaticShape, true, "pr_misl1T.DTS");
ME::RegisterObject("Projectiles","nano", 	ME::CreateObject, pr0, StaticShape, true, "pr_nano.DTS");
ME::RegisterObject("Projectiles","nano2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_nanoT.DTS");
ME::RegisterObject("Projectiles","proj1", 	ME::CreateObject, pr0, StaticShape, true, "pr_proj1.DTS");
ME::RegisterObject("Projectiles","proj12 trans", ME::CreateObject, pr0, StaticShape, true, "pr_proj1T.DTS");
ME::RegisterObject("Projectiles","proj2", 	ME::CreateObject, pr0, StaticShape, true, "pr_proj2.DTS");
ME::RegisterObject("Projectiles","proj22 trans", ME::CreateObject, pr0, StaticShape, true, "pr_proj2T.DTS");
ME::RegisterObject("Projectiles","prx", 	ME::CreateObject, pr0, StaticShape, true, "pr_prx.DTS");
ME::RegisterObject("Projectiles","rail", 	ME::CreateObject, pr0, StaticShape, true, "pr_rail.DTS");
ME::RegisterObject("Projectiles","rail2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_railT.DTS");
ME::RegisterObject("Projectiles","shell", 	ME::CreateObject, pr0, StaticShape, true, "pr_shell.DTS");
ME::RegisterObject("Projectiles","shell2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_shellT.DTS");
ME::RegisterObject("Projectiles","shrk", 	ME::CreateObject, pr0, StaticShape, true, "pr_shrk.DTS");
ME::RegisterObject("Projectiles","shrk2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_shrkT.DTS");
ME::RegisterObject("Projectiles","spr", 	ME::CreateObject, pr0, StaticShape, true, "pr_spr.DTS");
ME::RegisterObject("Projectiles","spr2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_sprT.DTS");
ME::RegisterObject("Projectiles","swrm", 	ME::CreateObject, pr0, StaticShape, true, "pr_swrm.DTS");
ME::RegisterObject("Projectiles","swrm2 trans", ME::CreateObject, pr0, StaticShape, true, "pr_swrmT.DTS");
ME::RegisterObject("Projectiles","vip", 	ME::CreateObject, pr0, StaticShape, true, "pr_vip.DTS");
ME::RegisterObject("Projectiles","vip2 trans", 	ME::CreateObject, pr0, StaticShape, true, "pr_vipT.DTS");

#Hidden Shapes
ME::RegisterObject("Hidden Shapes","Flame", 		ME::CreateObject, flame, 		StaticShape, true, "flame.DTS");
ME::RegisterObject("Hidden Shapes","Blastdoor", 	ME::CreateObject, xBlastdoor, 	StaticShape, true, "xBlastdoor.DTS");
ME::RegisterObject("Hidden Shapes","Blastdoor Anim", 	ME::CreateObject, xBlastdoor_Anim, 	StaticShape, true, "xBlastdoor_Anim.DTS");
ME::RegisterObject("Hidden Shapes","navPoint", 		ME::CreateObject, xnavPoint, 		StaticShape, true, "xnavPoint.DTS");
ME::RegisterObject("Hidden Shapes","splash", 		ME::CreateObject, xsplash, 		StaticShape, true, "xsplash.DTS");
ME::RegisterObject("Hidden Shapes","cryo",		ME::CreateObject, hcryo, 		StaticInterior, "hcryo.dis");

# Weapon Shapes
ME::RegisterObject("Weapon Shapes","wcARTL",	ME::CreateObject, ws0, StaticShape, true, "wc_ARTL.DTS");
ME::RegisterObject("Weapon Shapes","wcblink",	ME::CreateObject, ws0, StaticShape, true, "wc_blnk.DTS");
ME::RegisterObject("Weapon Shapes","wcemc",		ME::CreateObject, ws0, StaticShape, true, "wc_emc.DTS");
ME::RegisterObject("Weapon Shapes","wcnano",	ME::CreateObject, ws0, StaticShape, true, "wc_nano.DTS");
ME::RegisterObject("Weapon Shapes","wcpbw",		ME::CreateObject, ws0, StaticShape, true, "wc_pbw.DTS");
ME::RegisterObject("Weapon Shapes","wcrad",		ME::CreateObject, ws0, StaticShape, true, "wc_rad.DTS");
ME::RegisterObject("Weapon Shapes","wcrail",	ME::CreateObject, ws0, StaticShape, true, "wc_rail.DTS");
ME::RegisterObject("Weapon Shapes","wcshrk",	ME::CreateObject, ws0, StaticShape, true, "wc_shrk.DTS");
ME::RegisterObject("Weapon Shapes","wctlas",	ME::CreateObject, ws0, StaticShape, true, "wc_tlas.DTS");
ME::RegisterObject("Weapon Shapes","wgatc",		ME::CreateObject, ws0, StaticShape, true, "wg_atc.DTS");
ME::RegisterObject("Weapon Shapes","wgbc",		ME::CreateObject, ws0, StaticShape, true, "wg_bc.DTS");
ME::RegisterObject("Weapon Shapes","wgemp",		ME::CreateObject, ws0, StaticShape, true, "wg_emp.DTS");
ME::RegisterObject("Weapon Shapes","wghatc",	ME::CreateObject, ws0, StaticShape, true, "wg_hatc.DTS");
ME::RegisterObject("Weapon Shapes","wghbc",		ME::CreateObject, ws0, StaticShape, true, "wg_hbc.DTS");
ME::RegisterObject("Weapon Shapes","wghlas",	ME::CreateObject, ws0, StaticShape, true, "wg_hlas.DTS");
ME::RegisterObject("Weapon Shapes","wglas",		ME::CreateObject, ws0, StaticShape, true, "wg_las.DTS");
ME::RegisterObject("Weapon Shapes","wgmin",		ME::CreateObject, ws0, StaticShape, true, "wg_min.DTS");
ME::RegisterObject("Weapon Shapes","wgplas",	ME::CreateObject, ws0, StaticShape, true, "wg_plas.DTS");
ME::RegisterObject("Weapon Shapes","wgspr10",	ME::CreateObject, ws0, StaticShape, true, "wg_spr10.DTS");
ME::RegisterObject("Weapon Shapes","wgspr6",	ME::CreateObject, ws0, StaticShape, true, "wg_spr6.DTS");
ME::RegisterObject("Weapon Shapes","wgvip12",	ME::CreateObject, ws0, StaticShape, true, "wg_vip12.DTS");
ME::RegisterObject("Weapon Shapes","wgvip6",	ME::CreateObject, ws0, StaticShape, true, "wg_vip8.DTS");
ME::RegisterObject("Weapon Shapes","wmblas",	ME::CreateObject, ws0, StaticShape, true, "wm_blas.DTS");
ME::RegisterObject("Weapon Shapes","wmhbla",	ME::CreateObject, ws0, StaticShape, true, "wm_hbla.DTS");
ME::RegisterObject("Weapon Shapes","wmmfac",	ME::CreateObject, ws0, StaticShape, true, "wm_mfac.DTS");
ME::RegisterObject("Weapon Shapes","wmncan",	ME::CreateObject, ws0, StaticShape, true, "wm_ncan.DTS");
ME::RegisterObject("Weapon Shapes","wmqgun",	ME::CreateObject, ws0, StaticShape, true, "wm_qgun.DTS");
ME::RegisterObject("Weapon Shapes","wmsgun",	ME::CreateObject, ws0, StaticShape, true, "wm_sgun.DTS");
ME::RegisterObject("Weapon Shapes","wrARTL",	ME::CreateObject, ws0, StaticShape, true, "wr_ARTL.DTS");
ME::RegisterObject("Weapon Shapes","wtclas",	ME::CreateObject, ws0, StaticShape, true, "wt_clas.DTS");
ME::RegisterObject("Weapon Shapes","wtdis",		ME::CreateObject, ws0, StaticShape, true, "wt_dis.DTS");
ME::RegisterObject("Weapon Shapes","wtelf",		ME::CreateObject, ws0, StaticShape, true, "wt_elf.DTS");
ME::RegisterObject("Weapon Shapes","wtnike",	ME::CreateObject, ws0, StaticShape, true, "wt_nike.DTS");
ME::RegisterObject("Weapon Shapes","wtsupr",	ME::CreateObject, ws0, StaticShape, true, "wt_supr.DTS");
ME::RegisterObject("Weapon Shapes","wtswrm",	ME::CreateObject, ws0, StaticShape, true, "wt_swrm.DTS");
ME::RegisterObject("Weapon Shapes","wxARTL",	ME::CreateObject, ws0, StaticShape, true, "wx_ARTL.DTS");
ME::RegisterObject("Weapon Shapes","wxcan",		ME::CreateObject, ws0, StaticShape, true, "wx_can.DTS");
ME::RegisterObject("Weapon Shapes","wxgat",		ME::CreateObject, ws0, StaticShape, true, "wx_gat.DTS");
ME::RegisterObject("Weapon Shapes","wxgun",		ME::CreateObject, ws0, StaticShape, true, "wx_gun.DTS");
ME::RegisterObject("Weapon Shapes","wxTURM",	ME::CreateObject, ws0, StaticShape, true, "wx_TURM.DTS");
ME::RegisterObject("Weapon Shapes","Cybrid Laser",	ME::CreateObject, cLaserGun, 		StaticShape, true, "cLaserGun.DTS");

# Turret Shapes
ME::RegisterObject("Turret Shapes","Cybrid Laser Turret", 	ME::CreateObject, cLaserTurret, 	StaticShape, true, "cLaserTurret.DTS");
ME::RegisterObject("Turret Shapes","Cybrid Missile Turret", ME::CreateObject, cMissleTurret, 	StaticShape, true, "cMissleTurret.DTS");
ME::RegisterObject("Turret Shapes","Earth Cannon", 		ME::CreateObject, cCannon, 		StaticShape, true, "hCannon.DTS");
ME::RegisterObject("Turret Shapes","Desert Cannon", 		ME::CreateObject, hDesertCannon,	StaticShape, true, "hDesertCannon.DTS");
ME::RegisterObject("Turret Shapes","Desert Laser Short",	ME::CreateObject, hDesertLaserShort,StaticShape, true, "hDesertLaserShort.DTS");
ME::RegisterObject("Turret Shapes","Desert Laser Tall",	ME::CreateObject, hDesertLaserTall,	StaticShape, true, "hDesertLaserTall.DTS");
ME::RegisterObject("Turret Shapes","Desert Missile Short",	ME::CreateObject, hDesertMissleShort,StaticShape, true, "hDesertMissleShort.DTS");
ME::RegisterObject("Turret Shapes","Desert Missile Tall",	ME::CreateObject, hDesertMissleTall,StaticShape, true, "hDesertMissleTall.DTS");
ME::RegisterObject("Turret Shapes","Earth Laser Short",	ME::CreateObject, hEarthLaserShort,	StaticShape, true, "hEarthLaserShort.DTS");
ME::RegisterObject("Turret Shapes","Earth Laser Tall",	ME::CreateObject, hEarthLaserTall,	StaticShape, true, "hEarthLaserTall.DTS");
ME::RegisterObject("Turret Shapes","Earth Missile Short",	ME::CreateObject, hEarthMissleShort,StaticShape, true, "hEarthMissleShort.DTS");
ME::RegisterObject("Turret Shapes","Earth Missile Tall",	ME::CreateObject, hEarthMissleTall,	StaticShape, true, "hEarthMissleTall.DTS");
ME::RegisterObject("Turret Shapes","Mars Laser Short",	ME::CreateObject, hMarsLaserShort,	StaticShape, true, "hMarsLaserShort.DTS");
ME::RegisterObject("Turret Shapes","Mars Laser Tall",		ME::CreateObject, hMarsLaserTall,	StaticShape, true, "hMarsLaserTall.DTS");
ME::RegisterObject("Turret Shapes","Mars Missile Short",	ME::CreateObject, hMarsMissleShort,	StaticShape, true, "hMarsMissleShort.DTS");
ME::RegisterObject("Turret Shapes","Mars Missile Tall",	ME::CreateObject, hMarsMissleTall,	StaticShape, true, "hMarsMissleTall.DTS");
ME::RegisterObject("Turret Shapes","Moon Laser Short",	ME::CreateObject, hMoonLaserShort,	StaticShape, true, "hMoonLaserShort.DTS");
ME::RegisterObject("Turret Shapes","Moon Laser Tall",		ME::CreateObject, hMoonLaserTall,	StaticShape, true, "hMoonLaserTall.DTS");
ME::RegisterObject("Turret Shapes","Moon Missile Short",	ME::CreateObject, hMoonMissleShort,	StaticShape, true, "hMoonMissleShort.DTS");
ME::RegisterObject("Turret Shapes","Moon Missile Tall",	ME::CreateObject, hMoonMissleTall,	StaticShape, true, "hMoonMissleTall.DTS");
ME::RegisterObject("Turret Shapes","Titan Laser Short",	ME::CreateObject, hTitanLaserShort,	StaticShape, true, "hTitanLaserShort.DTS");
ME::RegisterObject("Turret Shapes","Titan Laser Tall",	ME::CreateObject, hTitanLaserTall,	StaticShape, true, "hTitanLaserTall.DTS");
ME::RegisterObject("Turret Shapes","Titan Missile Short",	ME::CreateObject, hTitanMissleShort,StaticShape, true, "hTitanMissleShort.DTS");
ME::RegisterObject("Turret Shapes","Titan Missile Tall",	ME::CreateObject, hTitanMissleTall,	StaticShape, true, "hTitanMissleTall.DTS");
ME::RegisterObject("Turret Shapes","Venus Laser Short",	ME::CreateObject, hVenusLaserShort,	StaticShape, true, "hVenusLaserShort.DTS");
ME::RegisterObject("Turret Shapes","Venus Laser Tall",	ME::CreateObject, hVenusLaserTall,	StaticShape, true, "hVenusLaserTall.DTS");
ME::RegisterObject("Turret Shapes","Venus Missile Short",	ME::CreateObject, hVenusMissleShort,StaticShape, true, "hVenusMissleShort.DTS");
ME::RegisterObject("Turret Shapes","Venus Missile Tall",	ME::CreateObject, hVenusMissleTall,	StaticShape, true, "hVenusMissleTall.DTS");

#Polygon Shapes
ME::RegisterObject("Polygon Shapes","Small Cylinder",	ME::CreateObject, ps0, StaticShape, true, "2m_cyln.dts");
ME::RegisterObject("Polygon Shapes","Small Pyramid",	ME::CreateObject, ps0, StaticShape, true, "2m_PYRM.dts");
ME::RegisterObject("Polygon Shapes","Small Cube",	ME::CreateObject, ps0, StaticShape, true, "cube2.dts");
ME::RegisterObject("Polygon Shapes","Yellow Arrow",	ME::CreateObject, ps0, StaticShape, true, "arrow5_y.dts");
ME::RegisterObject("Polygon Shapes","Blue Arrow",	ME::CreateObject, ps0, StaticShape, true, "arrow5_b.dts");
ME::RegisterObject("Polygon Shapes","Red Arrow",	ME::CreateObject, ps0, StaticShape, true, "arrow5_r.dts");
ME::RegisterObject("Polygon Shapes","Green Arrow",	ME::CreateObject, ps0, StaticShape, true, "arrow5_g.dts");
ME::RegisterObject("Polygon Shapes","Small Arrow",	ME::CreateObject, ps0, StaticShape, true, "arrow5.dts");
ME::RegisterObject("Polygon Shapes","Big Arrow",	ME::CreateObject, ps0, StaticShape, true, "arrow25.dts");
ME::RegisterObject("Polygon Shapes","Huge Arrow",	ME::CreateObject, ps0, StaticShape, true, "arrow50.dts");

#Debris Shapes
ME::RegisterObject("Debris","Large1",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_LRG_1.DTS");
ME::RegisterObject("Debris","Large2",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_LRG_2.DTS");
ME::RegisterObject("Debris","Large3",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_LRG_3.DTS");
ME::RegisterObject("Debris","Large4",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_LRG_4.DTS");
ME::RegisterObject("Debris","Man",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_MAN.DTS");
ME::RegisterObject("Debris","Med1",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_MED_1.DTS");
ME::RegisterObject("Debris","Med2",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_MED_2.DTS");
ME::RegisterObject("Debris","Med3",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_MED_3.DTS");
ME::RegisterObject("Debris","Med4",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_MED_4.DTS");
ME::RegisterObject("Debris","Pan1",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_PAN_1.DTS");
ME::RegisterObject("Debris","Pan2",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_PAN_2.DTS");
ME::RegisterObject("Debris","Pan3",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_PAN_3.DTS");
ME::RegisterObject("Debris","Sml1",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_SML_1.DTS");
ME::RegisterObject("Debris","Sml2",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_SML_2.DTS");
ME::RegisterObject("Debris","Sml3",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_SML_3.DTS");
ME::RegisterObject("Debris","Xlrg1",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_XLRG_1.DTS");
ME::RegisterObject("Debris","Xlrg2",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_XLRG_2.DTS");
ME::RegisterObject("Debris","Xlrg3",	ME::CreateObject, db0, StaticShape, true, "DEBRIS_XLRG_3.DTS");

#Hulk Shapes
ME::RegisterObject("Hulks","Hulk 10X10",	ME::CreateObject, hlk0, StaticShape, true, "hulk_10X10.dts");
ME::RegisterObject("Hulks","Hulk 10X20",	ME::CreateObject, hlk0, StaticShape, true, "hulk_10X20.dts");
ME::RegisterObject("Hulks","Hulk 20X30",	ME::CreateObject, hlk0, StaticShape, true, "hulk_20X30.dts");
ME::RegisterObject("Hulks","Hulk 20X40",	ME::CreateObject, hlk0, StaticShape, true, "hulk_20X40.dts");
ME::RegisterObject("Hulks","Hulk 40X40",	ME::CreateObject, hlk0, StaticShape, true, "hulk_40X40.dts");
ME::RegisterObject("Hulks","Hulk 45X30",	ME::CreateObject, hlk0, StaticShape, true, "hulk_45X30.dts");
ME::RegisterObject("Hulks","Hulk 10X5",	ME::CreateObject, hlk0, StaticShape, true, "hulk_4X5.dts");

# Vehicle Shapes
ME::RegisterObject("Veh Shapes","ca_BASL",	ME::CreateObject, ca_BASL, StaticShape, true, "ca_BASL.DTS");
ME::RegisterObject("Veh Shapes","cin_APOC",	ME::CreateObject, cin_APOC, StaticShape, true, "cin_APOC.DTS");
ME::RegisterObject("Veh Shapes","cin_basl",	ME::CreateObject, cin_basl, StaticShape, true, "cin_basl.dts");
ME::RegisterObject("Veh Shapes","cy_ADVO",	ME::CreateObject, cy_ADVO, StaticShape, true, "cy_ADVO.DTS");
ME::RegisterObject("Veh Shapes","cy_ARTL",	ME::CreateObject, cy_ARTL, StaticShape, true, "cy_ARTL.DTS");
ME::RegisterObject("Veh Shapes","cy_bolo",	ME::CreateObject, cy_bolo, StaticShape, true, "cy_bolo.DTS");
ME::RegisterObject("Veh Shapes","cy_cons",	ME::CreateObject, cy_cons, StaticShape, true, "cy_cons.DTS");
ME::RegisterObject("Veh Shapes","cy_drop",	ME::CreateObject, cy_drop, StaticShape, true, "cy_drop.DTS");
ME::RegisterObject("Veh Shapes","cy_EXEC",	ME::CreateObject, cy_EXEC, StaticShape, true, "cy_EXEC.DTS");
ME::RegisterObject("Veh Shapes","cy_GOAD",	ME::CreateObject, cy_GOAD, StaticShape, true, "cy_GOAD.DTS");
ME::RegisterObject("Veh Shapes","cy_JAMM",	ME::CreateObject, cy_JAMM, StaticShape, true, "cy_JAMM.DTS");
ME::RegisterObject("Veh Shapes","cy_JUDG",	ME::CreateObject, cy_JUDG, StaticShape, true, "cy_JUDG.DTS");
ME::RegisterObject("Veh Shapes","cy_OMNI",	ME::CreateObject, cy_OMNI, StaticShape, true, "cy_OMNI.DTS");
ME::RegisterObject("Veh Shapes","cy_PROM",	ME::CreateObject, cy_PROM, StaticShape, true, "cy_PROM.DTS");
ME::RegisterObject("Veh Shapes","cy_PROT",	ME::CreateObject, cy_PROT, StaticShape, true, "cy_PROT.dts");
ME::RegisterObject("Veh Shapes","cy_RECL",	ME::CreateObject, cy_RECL, StaticShape, true, "cy_RECL.DTS");
ME::RegisterObject("Veh Shapes","cy_SEEK",	ME::CreateObject, cy_SEEK, StaticShape, true, "cy_SEEK.DTS");
ME::RegisterObject("Veh Shapes","cy_SHEP",	ME::CreateObject, cy_SHEP, StaticShape, true, "cy_SHEP.DTS");
ME::RegisterObject("Veh Shapes","ha_APOC",	ME::CreateObject, ha_APOC, StaticShape, true, "ha_APOC.DTS");
ME::RegisterObject("Veh Shapes","ha_PRED",	ME::CreateObject, ha_PRED, StaticShape, true, "ha_PRED.DTS");
ME::RegisterObject("Veh Shapes","kn_APOC",	ME::CreateObject, kn_APOC, StaticShape, true, "kn_APOC.DTS");
ME::RegisterObject("Veh Shapes","kn_BANS",	ME::CreateObject, kn_BANS, StaticShape, true, "kn_BANS.DTS");
ME::RegisterObject("Veh Shapes","kn_BASL",	ME::CreateObject, kn_BASL, StaticShape, true, "kn_BASL.DTS");
ME::RegisterObject("Veh Shapes","kn_DISR",	ME::CreateObject, kn_DISR, StaticShape, true, "kn_DISR.DTS");
ME::RegisterObject("Veh Shapes","kn_drop",	ME::CreateObject, kn_drop, StaticShape, true, "kn_drop.DTS");
ME::RegisterObject("Veh Shapes","kn_GORG",	ME::CreateObject, kn_GORG, StaticShape, true, "kn_GORG.DTS");
ME::RegisterObject("Veh Shapes","kn_MINO",	ME::CreateObject, kn_MINO, StaticShape, true, "kn_MINO.DTS");
ME::RegisterObject("Veh Shapes","kn_MYRM",	ME::CreateObject, kn_MYRM, StaticShape, true, "kn_MYRM.DTS");
ME::RegisterObject("Veh Shapes","kn_PALA",	ME::CreateObject, kn_PALA, StaticShape, true, "kn_PALA.DTS");
ME::RegisterObject("Veh Shapes","kn_talon",	ME::CreateObject, kn_talon, StaticShape, true, "kn_talon.DTS");
ME::RegisterObject("Veh Shapes","mg_EXEC",	ME::CreateObject, mg_EXEC, StaticShape, true, "mg_EXEC.DTS");
ME::RegisterObject("Veh Shapes","mg_GOAD",	ME::CreateObject, mg_GOAD, StaticShape, true, "mg_GOAD.DTS");
ME::RegisterObject("Veh Shapes","mg_JUDG",	ME::CreateObject, mg_JUDG, StaticShape, true, "mg_JUDG.dts");
ME::RegisterObject("Veh Shapes","mg_SEEK",	ME::CreateObject, mg_SEEK, StaticShape, true, "mg_SEEK.DTS");
ME::RegisterObject("Veh Shapes","mg_SHEP",	ME::CreateObject, mg_SHEP, StaticShape, true, "mg_SHEP.DTS");
ME::RegisterObject("Veh Shapes","pi_apoc",	ME::CreateObject, pi_apoc, StaticShape, true, "pi_apoc.DTS");
ME::RegisterObject("Veh Shapes","pi_drea",	ME::CreateObject, pi_drea, StaticShape, true, "pi_drea.DTS");
ME::RegisterObject("Veh Shapes","pi_eman",	ME::CreateObject, pi_eman, StaticShape, true, "pi_eman.DTS");
ME::RegisterObject("Veh Shapes","pl_EXEC",	ME::CreateObject, pl_EXEC, StaticShape, true, "pl_EXEC.DTS");
ME::RegisterObject("Veh Shapes","pl_JUDG",	ME::CreateObject, pl_JUDG, StaticShape, true, "pl_JUDG.DTS");
ME::RegisterObject("Veh Shapes","rb_ARTL",	ME::CreateObject, rb_ARTL, StaticShape, true, "rb_ARTL.DTS");
ME::RegisterObject("Veh Shapes","rb_AVEN",	ME::CreateObject, rb_AVEN, StaticShape, true, "rb_AVEN.DTS");
ME::RegisterObject("Veh Shapes","rb_BIKE",	ME::CreateObject, rb_BIKE, StaticShape, true, "rb_BIKE.DTS");
ME::RegisterObject("Veh Shapes","rb_DREA",	ME::CreateObject, rb_DREA, StaticShape, true, "rb_DREA.DTS");
ME::RegisterObject("Veh Shapes","rb_EMAN",	ME::CreateObject, rb_EMAN, StaticShape, true, "rb_EMAN.DTS");
ME::RegisterObject("Veh Shapes","rb_FLTB",	ME::CreateObject, rb_FLTB, StaticShape, true, "rb_FLTB.DTS");
ME::RegisterObject("Veh Shapes","rb_FLTB_AMMO",		ME::CreateObject, rb_FLTB_AMMO, StaticShape, true, "rb_FLTB_AMMO.DTS");
ME::RegisterObject("Veh Shapes","rb_FLTB_BIG",		ME::CreateObject, rb_FLTB_BIG, StaticShape, true, "rb_FLTB_BIG.DTS");
ME::RegisterObject("Veh Shapes","rb_FLTB_BIG_AMMO",	ME::CreateObject, rb_FLTB_BIG_AMMO, StaticShape, true, "rb_FLTB_BIG_AMMO.DTS");
ME::RegisterObject("Veh Shapes","rb_FLTB_BIG_BOX",	ME::CreateObject, rb_FLTB_BIG_BOX, StaticShape, true, "rb_FLTB_BIG_BOX.DTS");
ME::RegisterObject("Veh Shapes","rb_FLTB_BOX",		ME::CreateObject, rb_FLTB_BOX, StaticShape, true, "rb_FLTB_BOX.DTS");
ME::RegisterObject("Veh Shapes","rb_OLY",	ME::CreateObject, rb_OLY, StaticShape, true, "rb_OLY.DTS");
ME::RegisterObject("Veh Shapes","rb_THUM",	ME::CreateObject, rb_THUM, StaticShape, true, "rb_THUM.DTS");
ME::RegisterObject("Veh Shapes","ss_bus",	ME::CreateObject, ss_bus, StaticShape, true, "ss_bus.DTS");
ME::RegisterObject("Veh Shapes","tr_APOC",	ME::CreateObject, tr_APOC, StaticShape, true, "tr_APOC.DTS");
ME::RegisterObject("Veh Shapes","tr_BANS",	ME::CreateObject, tr_BANS, StaticShape, true, "tr_BANS.DTS");
ME::RegisterObject("Veh Shapes","tr_BASL",	ME::CreateObject, tr_BANS, StaticShape, true, "tr_BASL.DTS");
ME::RegisterObject("Veh Shapes","TR_CARG",	ME::CreateObject, TR_CARG, StaticShape, true, "TR_CARG.DTS");
ME::RegisterObject("Veh Shapes","tr_conv",	ME::CreateObject, tr_conv, StaticShape, true, "tr_conv.DTS");
ME::RegisterObject("Veh Shapes","tr_DISR",	ME::CreateObject, tr_DISR, StaticShape, true, "tr_DISR.DTS");
ME::RegisterObject("Veh Shapes","tr_drac",	ME::CreateObject, tr_drac, StaticShape, true, "tr_drac.DTS");
ME::RegisterObject("Veh Shapes","tr_drop",	ME::CreateObject, tr_drop, StaticShape, true, "tr_drop.DTS");
ME::RegisterObject("Veh Shapes","TR_ESCAPE",	ME::CreateObject, TR_ESCAPE, StaticShape, true, "TR_ESCAPE.dts");
ME::RegisterObject("Veh Shapes","TR_FLTB",	ME::CreateObject, TR_FLTB, StaticShape, true, "TR_FLTB.dts");
ME::RegisterObject("Veh Shapes","TR_FLTB_AMMO",	ME::CreateObject, TR_FLTB_AMMO, StaticShape, true, "TR_FLTB_AMMO.DTS");
ME::RegisterObject("Veh Shapes","TR_FLTB_BIG_AMMO",	ME::CreateObject, TR_FLTB_BIG_AMMO, StaticShape, true, "TR_FLTB_BIG_AMMO.DTS");
ME::RegisterObject("Veh Shapes","TR_FLTB_BIG_PERSONEL",	ME::CreateObject, TR_FLTB_BIG_PERSONEL, StaticShape, true, "TR_FLTB_BIG_PERSONEL.DTS");
ME::RegisterObject("Veh Shapes","TR_FLTB_FUEL",		ME::CreateObject, TR_FLTB_FUEL, StaticShape, true, "TR_FLTB_FUEL.DTS");
ME::RegisterObject("Veh Shapes","TR_FLTB_MINO",		ME::CreateObject, TR_FLTB_MINO, StaticShape, true, "TR_FLTB_MINO.DTS");
ME::RegisterObject("Veh Shapes","tr_GORG",	ME::CreateObject, tr_GORG, StaticShape, true, "tr_GORG.DTS");
ME::RegisterObject("Veh Shapes","tr_MINO",	ME::CreateObject, tr_MINO, StaticShape, true, "tr_MINO.DTS");
ME::RegisterObject("Veh Shapes","tr_MYRM",	ME::CreateObject, tr_MYRM, StaticShape, true, "tr_MYRM.DTS");
ME::RegisterObject("Veh Shapes","tr_NIKE",	ME::CreateObject, tr_NIKE, StaticShape, true, "tr_NIKE.DTS");
ME::RegisterObject("Veh Shapes","tr_PALA",	ME::CreateObject, tr_PALA, StaticShape, true, "tr_PALA.DTS");
ME::RegisterObject("Veh Shapes","tr_SOVE",	ME::CreateObject, tr_SOVE, StaticShape, true, "tr_SOVE.DTS");
ME::RegisterObject("Veh Shapes","tr_STAR",	ME::CreateObject, tr_STAR, StaticShape, true, "tr_STAR.DTS");
ME::RegisterObject("Veh Shapes","tr_SUPR",	ME::CreateObject, tr_SUPR, StaticShape, true, "tr_SUPR.DTS");
ME::RegisterObject("Veh Shapes","tr_SURV",	ME::CreateObject, tr_SURV, StaticShape, true, "tr_SURV.DTS");
ME::RegisterObject("Veh Shapes","tr_talon",	ME::CreateObject, tr_talon, StaticShape, true, "tr_talon.DTS");
ME::RegisterObject("Veh Shapes","TR_UTIL",	ME::CreateObject, TR_UTIL, StaticShape, true, "TR_UTIL.dts");

#Buzzbum's Mapmod with additions - v3.0
#Additions by S-110
#Re-organized a bit
#A few shapes present in the GameObjects.vol do not work for various reasons, so these
#are not included in this mod, unless already present.
# "trans" in a shape's label indicates a transparent shape which cannot be viewed.
#
#RegisterObjects.cs: Modified Edition
#Yet more additions by Super Powio 2-20-2004
#Special thanks to Izzy for finding out about pointlights.